/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpLoadBalancerFactory;
import io.servicetalk.http.api.MultiAddressHttpClientFilterFactory;
import io.servicetalk.http.api.StrategyInfluencerChainBuilder;
import io.servicetalk.http.api.StreamingHttpClientFilterFactory;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;

final class ClientStrategyInfluencerChainBuilder {
    private final StrategyInfluencerChainBuilder connFactoryChain;
    private final StrategyInfluencerChainBuilder connFilterChain;
    private final StrategyInfluencerChainBuilder clientChain;

    ClientStrategyInfluencerChainBuilder() {
        this.connFactoryChain = new StrategyInfluencerChainBuilder();
        this.connFilterChain = new StrategyInfluencerChainBuilder();
        this.clientChain = new StrategyInfluencerChainBuilder();
    }

    private ClientStrategyInfluencerChainBuilder(ClientStrategyInfluencerChainBuilder from) {
        this.connFactoryChain = from.connFactoryChain.copy();
        this.connFilterChain = from.connFilterChain.copy();
        this.clientChain = from.clientChain.copy();
    }

    void add(MultiAddressHttpClientFilterFactory<?> multiAddressHttpClientFilter) {
        if (!this.clientChain.appendIfInfluencer(multiAddressHttpClientFilter)) {
            this.clientChain.append(HttpExecutionStrategyInfluencer.defaultStreamingInfluencer());
        }
    }

    void add(StreamingHttpClientFilterFactory clientFilter) {
        if (!this.clientChain.appendIfInfluencer(clientFilter)) {
            this.clientChain.append(HttpExecutionStrategyInfluencer.defaultStreamingInfluencer());
        }
    }

    void add(HttpLoadBalancerFactory<?> lb) {
        if (!this.clientChain.prependIfInfluencer(lb)) {
            this.clientChain.prepend(HttpExecutionStrategyInfluencer.defaultStreamingInfluencer());
        }
    }

    void add(ConnectionFactoryFilter<?, FilterableStreamingHttpConnection> connectionFactoryFilter) {
        if (!this.connFactoryChain.appendIfInfluencer(connectionFactoryFilter)) {
            this.connFactoryChain.append(HttpExecutionStrategyInfluencer.defaultStreamingInfluencer());
        }
    }

    void add(StreamingHttpConnectionFilterFactory connectionFilter) {
        if (!this.connFilterChain.appendIfInfluencer(connectionFilter)) {
            this.connFilterChain.append(HttpExecutionStrategyInfluencer.defaultStreamingInfluencer());
        }
    }

    HttpExecutionStrategyInfluencer buildForClient(HttpExecutionStrategy transportStrategy) {
        StrategyInfluencerChainBuilder forClient = new StrategyInfluencerChainBuilder();
        forClient.append(this.buildForConnectionFactory(transportStrategy));
        forClient.append(this.clientChain.build());
        return forClient.build();
    }

    HttpExecutionStrategyInfluencer buildForConnectionFactory(HttpExecutionStrategy transportStrategy) {
        StrategyInfluencerChainBuilder forConnFactory = new StrategyInfluencerChainBuilder();
        forConnFactory.append(this.connFilterChain.build());
        forConnFactory.append(this.connFactoryChain.build(transportStrategy));
        return forConnFactory.build();
    }

    ClientStrategyInfluencerChainBuilder copy() {
        return new ClientStrategyInfluencerChainBuilder(this);
    }
}

