/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.netty;

import io.netty.channel.Channel;
import io.servicetalk.client.api.ConnectionFactoryFilter;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyController;
import io.servicetalk.client.api.internal.ReservableRequestConcurrencyControllers;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.http.api.FilterableStreamingHttpConnection;
import io.servicetalk.http.api.FilterableStreamingHttpLoadBalancedConnection;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpExecutionContext;
import io.servicetalk.http.api.HttpExecutionStrategyInfluencer;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.StreamingHttpConnectionFilterFactory;
import io.servicetalk.http.api.StreamingHttpRequestResponseFactory;
import io.servicetalk.http.netty.AbstractLBHttpConnectionFactory;
import io.servicetalk.http.netty.AlpnChannelSingle;
import io.servicetalk.http.netty.H1ProtocolConfig;
import io.servicetalk.http.netty.H2ClientParentChannelInitializer;
import io.servicetalk.http.netty.H2ClientParentConnectionContext;
import io.servicetalk.http.netty.H2ProtocolConfig;
import io.servicetalk.http.netty.PipelinedStreamingHttpConnection;
import io.servicetalk.http.netty.ReadOnlyHttpClientConfig;
import io.servicetalk.http.netty.StreamingConnectionFactory;
import io.servicetalk.tcp.netty.internal.ReadOnlyTcpClientConfig;
import io.servicetalk.tcp.netty.internal.TcpClientChannelInitializer;
import io.servicetalk.tcp.netty.internal.TcpConnector;
import io.servicetalk.transport.api.ConnectionObserver;
import io.servicetalk.transport.api.TransportObserver;
import io.servicetalk.transport.netty.internal.NettyConnection;
import java.util.function.Function;
import javax.annotation.Nullable;

final class AlpnLBHttpConnectionFactory<ResolvedAddress>
extends AbstractLBHttpConnectionFactory<ResolvedAddress> {
    AlpnLBHttpConnectionFactory(ReadOnlyHttpClientConfig config, HttpExecutionContext executionContext, @Nullable StreamingHttpConnectionFilterFactory connectionFilterFunction, Function<HttpProtocolVersion, StreamingHttpRequestResponseFactory> reqRespFactoryFunc, HttpExecutionStrategyInfluencer strategyInfluencer, ConnectionFactoryFilter<ResolvedAddress, FilterableStreamingHttpConnection> connectionFactoryFilter, Function<FilterableStreamingHttpConnection, FilterableStreamingHttpLoadBalancedConnection> protocolBinding) {
        super(config, executionContext, connectionFilterFunction, reqRespFactoryFunc, strategyInfluencer, connectionFactoryFilter, protocolBinding);
        assert (config.h1Config() != null && config.h2Config() != null);
    }

    @Override
    Single<FilterableStreamingHttpConnection> newFilterableConnection(ResolvedAddress resolvedAddress, TransportObserver observer) {
        ReadOnlyTcpClientConfig roTcpClientConfig = this.config.tcpConfig();
        return TcpConnector.connect(null, resolvedAddress, roTcpClientConfig, false, this.executionContext, this::createConnection, observer);
    }

    private Single<FilterableStreamingHttpConnection> createConnection(Channel channel, ConnectionObserver connectionObserver) {
        ReadOnlyTcpClientConfig tcpConfig = this.config.tcpConfig();
        return new AlpnChannelSingle(channel, new TcpClientChannelInitializer(tcpConfig, connectionObserver), false).flatMap(protocol -> {
            switch (protocol) {
                case "http/1.1": {
                    H1ProtocolConfig h1Config = this.config.h1Config();
                    assert (h1Config != null);
                    return StreamingConnectionFactory.createConnection(channel, this.executionContext, this.config, AlpnChannelSingle.NoopChannelInitializer.INSTANCE, connectionObserver).map(conn -> new PipelinedStreamingHttpConnection((NettyConnection<Object, Object>)conn, h1Config, this.executionContext, (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_1_1), this.config.allowDropTrailersReadFromTransport()));
                }
                case "h2": {
                    H2ProtocolConfig h2Config = this.config.h2Config();
                    assert (h2Config != null);
                    return H2ClientParentConnectionContext.initChannel(channel, this.executionContext.bufferAllocator(), this.executionContext.executor(), h2Config, (StreamingHttpRequestResponseFactory)this.reqRespFactoryFunc.apply(HttpProtocolVersion.HTTP_2_0), tcpConfig.flushStrategy(), tcpConfig.idleTimeoutMs(), this.executionContext.executionStrategy(), new H2ClientParentChannelInitializer(h2Config), connectionObserver, this.config.allowDropTrailersReadFromTransport());
                }
            }
            return Single.failed(new IllegalStateException("Unknown ALPN protocol negotiated: " + protocol));
        });
    }

    @Override
    ReservableRequestConcurrencyController newConcurrencyController(FilterableStreamingHttpConnection connection, Completable onClosing) {
        return ReservableRequestConcurrencyControllers.newController(connection.transportEventStream(HttpEventKey.MAX_CONCURRENCY), onClosing, 1);
    }
}

