/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.buffer.api.Buffer;
import io.servicetalk.buffer.api.BufferAllocator;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Processors;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.PublisherOperator;
import io.servicetalk.concurrent.api.ScanWithMapper;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.SourceAdapters;
import io.servicetalk.http.api.DefaultPayloadInfo;
import io.servicetalk.http.api.HeaderUtils;
import io.servicetalk.http.api.HttpDataSourceTransformations;
import io.servicetalk.http.api.HttpHeaders;
import io.servicetalk.http.api.HttpHeadersFactory;
import io.servicetalk.http.api.HttpProtocolVersion;
import io.servicetalk.http.api.HttpSerializer;
import io.servicetalk.http.api.PayloadInfo;
import io.servicetalk.http.api.TrailersTransformer;
import io.servicetalk.http.api.UnsupportedHttpChunkException;
import java.util.Objects;
import java.util.function.Function;
import java.util.function.UnaryOperator;
import javax.annotation.Nullable;

final class StreamingHttpPayloadHolder
implements PayloadInfo {
    private final HttpHeaders headers;
    private final BufferAllocator allocator;
    private final DefaultPayloadInfo payloadInfo;
    private final HttpHeadersFactory headersFactory;
    private final boolean h1TrailersSupported;
    @Nullable
    private Publisher<?> messageBody;

    StreamingHttpPayloadHolder(HttpHeaders headers, BufferAllocator allocator, @Nullable Publisher<?> messageBody, DefaultPayloadInfo messageBodyInfo, HttpHeadersFactory headersFactory, HttpProtocolVersion version) {
        assert (messageBody != null || !messageBodyInfo.mayHaveTrailers());
        this.headers = Objects.requireNonNull(headers);
        this.allocator = Objects.requireNonNull(allocator);
        this.payloadInfo = Objects.requireNonNull(messageBodyInfo);
        this.headersFactory = Objects.requireNonNull(headersFactory);
        this.h1TrailersSupported = HttpProtocolVersion.h1TrailersSupported(version);
        this.messageBody = messageBody;
    }

    Publisher<Buffer> payloadBody() {
        return this.messageBody == null ? Publisher.empty() : (this.payloadInfo.mayHaveTrailers() || !this.payloadInfo.onlyEmitsBuffer() ? this.messageBody.liftSync(HttpDataSourceTransformations.HttpTransportBufferFilterOperator.INSTANCE) : this.messageBody);
    }

    @Deprecated
    Publisher<Object> payloadBodyAndTrailers() {
        if (this.messageBody != null && this.payloadInfo.mayHaveTrailers()) {
            Publisher<?> oldMessageBody = this.messageBody;
            return Publisher.defer(() -> {
                SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor = Processors.newSingleProcessor();
                return StreamingHttpPayloadHolder.mergeEnsureTrailers(oldMessageBody.liftSync(new PreserveTrailersOperator(trailersProcessor)), SourceAdapters.fromSource(trailersProcessor), this.headersFactory).subscribeShareContext();
            });
        }
        return this.messageBody();
    }

    Publisher<Object> messageBody() {
        return this.messageBody == null ? Publisher.empty() : this.messageBody;
    }

    void payloadBody(Publisher<Buffer> payloadBody) {
        if (this.messageBody == null) {
            this.messageBody = Objects.requireNonNull(payloadBody);
            this.payloadInfo.setOnlyEmitsBuffer(true);
        } else if (this.payloadInfo.mayHaveTrailers()) {
            Publisher<?> oldMessageBody = this.messageBody;
            this.messageBody = Publisher.defer(() -> {
                SingleSource.Processor trailersProcessor = Processors.newSingleProcessor();
                return StreamingHttpPayloadHolder.merge(payloadBody.liftSync(new HttpDataSourceTransformations.BridgeFlowControlAndDiscardOperator(oldMessageBody.liftSync(new PreserveTrailersBufferOperator(trailersProcessor)))), SourceAdapters.fromSource(trailersProcessor)).subscribeShareContext();
            });
        } else {
            this.messageBody = payloadBody.liftSync(new HttpDataSourceTransformations.BridgeFlowControlAndDiscardOperator(this.messageBody));
            this.payloadInfo.setOnlyEmitsBuffer(true);
        }
    }

    <T> void payloadBody(Publisher<T> payloadBody, HttpSerializer<T> serializer) {
        this.payloadBody(serializer.serialize(this.headers, payloadBody, this.allocator));
    }

    <T> void transformPayloadBody(Function<Publisher<Buffer>, Publisher<T>> transformer, HttpSerializer<T> serializer) {
        this.transformPayloadBody(bufPub -> serializer.serialize(this.headers, (Publisher)transformer.apply((Publisher<Buffer>)bufPub), this.allocator));
    }

    void transformPayloadBody(UnaryOperator<Publisher<Buffer>> transformer) {
        if (this.messageBody != null && this.payloadInfo.mayHaveTrailers()) {
            Publisher<?> oldMessageBody = this.messageBody;
            this.messageBody = Publisher.defer(() -> {
                SingleSource.Processor trailersProcessor = Processors.newSingleProcessor();
                return StreamingHttpPayloadHolder.merge((Publisher)transformer.apply(oldMessageBody.liftSync(new PreserveTrailersBufferOperator(trailersProcessor))), SourceAdapters.fromSource(trailersProcessor)).subscribeShareContext();
            });
        } else {
            this.messageBody = (Publisher)Objects.requireNonNull(transformer.apply(this.payloadBody()));
            this.payloadInfo.setOnlyEmitsBuffer(true);
        }
    }

    @Deprecated
    void transformRawPayloadBody(UnaryOperator<Publisher<?>> transformer) {
        this.payloadInfo.setOnlyEmitsBuffer(false);
        this.payloadInfo.setMayHaveTrailers(true);
        if (this.messageBody != null && this.payloadInfo.mayHaveTrailers()) {
            Publisher<?> oldMessageBody = this.messageBody;
            this.messageBody = Publisher.defer(() -> {
                SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor = Processors.newSingleProcessor();
                return StreamingHttpPayloadHolder.merge((Publisher)transformer.apply(oldMessageBody.liftSync(new PreserveTrailersOperator(trailersProcessor))), SourceAdapters.fromSource(trailersProcessor)).subscribeShareContext();
            });
        } else {
            this.messageBody = (Publisher)transformer.apply(this.messageBody());
        }
    }

    void transformMessageBody(UnaryOperator<Publisher<?>> transformer) {
        this.payloadInfo.setOnlyEmitsBuffer(false);
        this.messageBody = (Publisher)transformer.apply(this.messageBody());
    }

    <T> void transform(TrailersTransformer<T, Buffer> trailersTransformer) {
        this.transformWithTrailersUnchecked(trailersTransformer, o -> (Buffer)o);
    }

    @Deprecated
    <T> void transformRaw(TrailersTransformer<T, Object> trailersTransformer) {
        this.payloadInfo.setOnlyEmitsBuffer(false);
        this.transformWithTrailersUnchecked(trailersTransformer, Function.identity());
    }

    Single<HttpDataSourceTransformations.PayloadAndTrailers> aggregate() {
        this.payloadInfo.setSafeToAggregate(true);
        return HttpDataSourceTransformations.aggregatePayloadAndTrailers(this.messageBody(), this.allocator);
    }

    private <T, P> void transformWithTrailersUnchecked(final TrailersTransformer<T, P> trailersTransformer, final Function<Object, P> caster) {
        if (this.h1TrailersSupported) {
            HeaderUtils.addChunkedEncoding(this.headers);
        }
        this.payloadInfo.setMayHaveTrailers(true);
        this.messageBody = this.messageBody == null ? Publisher.from(trailersTransformer.payloadComplete(trailersTransformer.newState(), this.headersFactory.newEmptyTrailers())) : this.messageBody.scanWith(() -> new ScanWithMapper<Object, Object>(){
            @Nullable
            private HttpHeaders trailers;
            @Nullable
            private final Object state;
            {
                this.state = trailersTransformer.newState();
            }

            @Override
            public Object mapOnNext(@Nullable Object next) {
                if (next instanceof HttpHeaders) {
                    if (this.trailers != null) {
                        StreamingHttpPayloadHolder.throwDuplicateTrailersException(this.trailers, next);
                    }
                    this.trailers = (HttpHeaders)next;
                    return trailersTransformer.payloadComplete(this.state, this.trailers);
                }
                if (this.trailers != null) {
                    StreamingHttpPayloadHolder.throwOnNextAfterTrailersException(this.trailers, next);
                }
                return trailersTransformer.accept(this.state, caster.apply(Objects.requireNonNull(next)));
            }

            @Override
            public Object mapOnError(Throwable t) throws Throwable {
                return trailersTransformer.catchPayloadFailure(this.state, t, StreamingHttpPayloadHolder.this.headersFactory.newEmptyTrailers());
            }

            @Override
            public Object mapOnComplete() {
                return trailersTransformer.payloadComplete(this.state, StreamingHttpPayloadHolder.this.headersFactory.newEmptyTrailers());
            }

            @Override
            public boolean mapTerminal() {
                return this.trailers == null;
            }
        });
    }

    @Override
    public boolean isSafeToAggregate() {
        return this.payloadInfo.isSafeToAggregate();
    }

    @Override
    public boolean mayHaveTrailers() {
        return this.payloadInfo.mayHaveTrailers();
    }

    @Override
    public boolean onlyEmitsBuffer() {
        return this.payloadInfo.onlyEmitsBuffer();
    }

    BufferAllocator allocator() {
        return this.allocator;
    }

    HttpHeadersFactory headersFactory() {
        return this.headersFactory;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        StreamingHttpPayloadHolder that = (StreamingHttpPayloadHolder)o;
        if (!this.headers.equals(that.headers)) {
            return false;
        }
        if (!this.allocator.equals(that.allocator)) {
            return false;
        }
        if (!this.payloadInfo.equals(that.payloadInfo)) {
            return false;
        }
        if (!this.headersFactory.equals(that.headersFactory)) {
            return false;
        }
        return Objects.equals(this.messageBody, that.messageBody);
    }

    public int hashCode() {
        int result = this.headers.hashCode();
        result = 31 * result + this.allocator.hashCode();
        result = 31 * result + this.payloadInfo.hashCode();
        result = 31 * result + this.headersFactory.hashCode();
        result = 31 * result + Objects.hashCode(this.messageBody);
        return result;
    }

    private static void throwDuplicateTrailersException(HttpHeaders trailers, Object o) {
        throw new IllegalStateException("trailers already set to: " + trailers + " but duplicate trailers seen: " + o);
    }

    private static void throwOnNextAfterTrailersException(HttpHeaders trailers, @Nullable Object o) {
        throw new IllegalStateException("trailers must be the last onNext signal, but got: " + o + " after: " + trailers);
    }

    private static Publisher<?> merge(Publisher<?> p, Single<HttpHeaders> s) {
        return Publisher.from(p, s.toPublisher().filter(Objects::nonNull)).flatMapMerge(Function.identity(), 2);
    }

    private static Publisher<Object> mergeEnsureTrailers(Publisher<?> p, Single<HttpHeaders> s, HttpHeadersFactory headersFactory) {
        return Publisher.from(p, s.map(t -> t == null ? headersFactory.newEmptyTrailers() : t).toPublisher()).flatMapMerge(Function.identity(), 2);
    }

    private static abstract class AbstractPreserveTrailersSubscriber<T>
    implements PublisherSource.Subscriber<Object> {
        final PublisherSource.Subscriber<? super T> target;
        final SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor;
        @Nullable
        HttpHeaders trailers;

        AbstractPreserveTrailersSubscriber(PublisherSource.Subscriber<? super T> target, SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor) {
            this.target = target;
            this.trailersProcessor = trailersProcessor;
        }

        @Override
        public final void onSubscribe(PublisherSource.Subscription subscription) {
            this.target.onSubscribe(subscription);
        }

        @Override
        public abstract void onNext(Object var1);

        @Override
        public final void onError(Throwable t) {
            try {
                this.trailersProcessor.onError(t);
            }
            finally {
                this.target.onError(t);
            }
        }

        @Override
        public final void onComplete() {
            try {
                if (this.trailers == null) {
                    this.trailersProcessor.onSuccess(null);
                }
            }
            finally {
                this.target.onComplete();
            }
        }
    }

    private static final class PreserveTrailersOperator
    implements PublisherOperator<Object, Object> {
        private final SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor;

        PreserveTrailersOperator(SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor) {
            this.trailersProcessor = trailersProcessor;
        }

        @Override
        public PublisherSource.Subscriber<? super Object> apply(PublisherSource.Subscriber<? super Object> subscriber) {
            return new PreserveTrailersSubscriber(subscriber, this.trailersProcessor);
        }

        private static final class PreserveTrailersSubscriber
        extends AbstractPreserveTrailersSubscriber<Object> {
            PreserveTrailersSubscriber(PublisherSource.Subscriber<? super Object> target, SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor) {
                super(target, trailersProcessor);
            }

            @Override
            public void onNext(Object o) {
                if (o instanceof HttpHeaders) {
                    if (this.trailers != null) {
                        StreamingHttpPayloadHolder.throwDuplicateTrailersException(this.trailers, o);
                    }
                    this.trailers = (HttpHeaders)o;
                    this.trailersProcessor.onSuccess(this.trailers);
                } else {
                    this.target.onNext(o);
                }
            }
        }
    }

    private static final class PreserveTrailersBufferOperator
    implements PublisherOperator<Object, Buffer> {
        private final SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor;

        private PreserveTrailersBufferOperator(SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor) {
            this.trailersProcessor = trailersProcessor;
        }

        @Override
        public PublisherSource.Subscriber<? super Object> apply(PublisherSource.Subscriber<? super Buffer> subscriber) {
            return new PreserveTrailersBufferSubscriber(subscriber, this.trailersProcessor);
        }

        private static final class PreserveTrailersBufferSubscriber
        extends AbstractPreserveTrailersSubscriber<Buffer> {
            PreserveTrailersBufferSubscriber(PublisherSource.Subscriber<? super Buffer> target, SingleSource.Processor<HttpHeaders, HttpHeaders> trailersProcessor) {
                super(target, trailersProcessor);
            }

            @Override
            public void onNext(Object o) {
                if (o instanceof Buffer) {
                    this.target.onNext((Buffer)o);
                } else if (o instanceof HttpHeaders) {
                    if (this.trailers != null) {
                        StreamingHttpPayloadHolder.throwDuplicateTrailersException(this.trailers, o);
                    }
                    this.trailers = (HttpHeaders)o;
                    this.trailersProcessor.onSuccess(this.trailers);
                } else {
                    throw new UnsupportedHttpChunkException(o);
                }
            }
        }
    }
}

