/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.NoSuchElementException;
import java.util.Objects;
import java.util.Set;
import java.util.Spliterator;
import java.util.Spliterators;
import javax.annotation.Nullable;

final class HttpQuery
implements Iterable<Map.Entry<String, String>> {
    private static final int DEFAULT_LIST_SIZE = 2;
    private final Map<String, List<String>> params;
    private boolean dirty;

    HttpQuery(Map<String, List<String>> params) {
        this.params = Objects.requireNonNull(params);
    }

    @Nullable
    public String get(String key) {
        List<String> values = this.params.get(key);
        if (values == null || values.isEmpty()) {
            return null;
        }
        return values.get(0);
    }

    public Iterator<String> valuesIterator(String key) {
        List<String> values = this.params.get(key);
        if (values == null) {
            return Collections.emptyIterator();
        }
        return new ValuesIterator(values.iterator(), () -> {
            if (values.isEmpty()) {
                this.params.remove(key);
            }
            this.markDirty();
        });
    }

    public Iterable<String> values(final String key) {
        return new Iterable<String>(){

            @Override
            public Iterator<String> iterator() {
                return HttpQuery.this.valuesIterator(key);
            }

            @Override
            public Spliterator<String> spliterator() {
                List values = (List)HttpQuery.this.params.get(key);
                return Spliterators.spliterator(this.iterator(), values == null ? 0L : (long)values.size(), 64);
            }
        };
    }

    public Set<String> keys() {
        return Collections.unmodifiableSet(this.params.keySet());
    }

    public HttpQuery add(String key, String value) {
        this.validateQueryParam(key, value);
        this.getValues(key).add(value);
        this.markDirty();
        return this;
    }

    public HttpQuery add(String key, Iterable<String> values) {
        List<String> paramValues = this.getValues(key);
        for (String value : values) {
            paramValues.add(value);
        }
        this.markDirty();
        return this;
    }

    public HttpQuery add(String key, String ... values) {
        List<String> paramValues = this.getValues(key);
        Collections.addAll(paramValues, values);
        this.markDirty();
        return this;
    }

    public HttpQuery set(String key, String value) {
        this.validateQueryParam(key, value);
        ArrayList<String> list = new ArrayList<String>(2);
        list.add(value);
        this.markDirty();
        this.params.put(key, list);
        return this;
    }

    public HttpQuery set(String key, Iterable<String> values) {
        ArrayList<String> list = new ArrayList<String>(2);
        for (String value : values) {
            list.add(value);
        }
        this.params.put(key, list);
        this.markDirty();
        return this;
    }

    public HttpQuery set(String key, String ... values) {
        ArrayList list = new ArrayList(2);
        Collections.addAll(list, values);
        this.params.put(key, list);
        this.markDirty();
        return this;
    }

    public boolean contains(String key, String value) {
        Iterator<String> values = this.valuesIterator(key);
        while (values.hasNext()) {
            if (!value.equals(values.next())) continue;
            return true;
        }
        return false;
    }

    public boolean remove(String key) {
        if (this.params.remove(key) != null) {
            this.markDirty();
            return true;
        }
        return false;
    }

    public boolean remove(String key, String value) {
        Iterator<String> values = this.valuesIterator(key);
        while (values.hasNext()) {
            if (!value.equals(values.next())) continue;
            values.remove();
            this.markDirty();
            return true;
        }
        return false;
    }

    public int size() {
        int size = 0;
        for (Map.Entry<String, List<String>> entry : this.params.entrySet()) {
            size += entry.getValue().size();
        }
        return size;
    }

    @Override
    public Iterator<Map.Entry<String, String>> iterator() {
        return new QueryIterator(this.params.entrySet().iterator(), this::markDirty);
    }

    Map<String, List<String>> queryParameters() {
        return this.params;
    }

    boolean isDirty() {
        return this.dirty;
    }

    void resetDirty() {
        this.dirty = false;
    }

    private void markDirty() {
        this.dirty = true;
    }

    private List<String> getValues(String key) {
        return this.params.computeIfAbsent(key, k -> new ArrayList(2));
    }

    private void validateQueryParam(String key, String value) {
        if (key == null || key.isEmpty()) {
            throw new IllegalArgumentException("Null or empty query parameter names are not allowed.");
        }
        if (value == null) {
            throw new IllegalArgumentException("Null query parameter values are not allowed.");
        }
    }

    private static final class QueryIterator
    implements Iterator<Map.Entry<String, String>> {
        private final Iterator<Map.Entry<String, List<String>>> mapIterator;
        private final Runnable queryParamsUpdater;
        @Nullable
        private String key;
        private List<String> value;
        private Iterator<String> listIterator;

        private QueryIterator(Iterator<Map.Entry<String, List<String>>> mapIterator, Runnable queryParamsUpdater) {
            this.mapIterator = mapIterator;
            this.queryParamsUpdater = queryParamsUpdater;
            this.listIterator = Collections.emptyIterator();
            this.value = Collections.emptyList();
        }

        @Override
        public boolean hasNext() {
            if (this.listIterator.hasNext()) {
                return true;
            }
            while (this.mapIterator.hasNext()) {
                Map.Entry<String, List<String>> entry = this.mapIterator.next();
                this.key = entry.getKey();
                this.value = entry.getValue();
                this.listIterator = this.value.iterator();
                if (!this.listIterator.hasNext()) continue;
                return true;
            }
            return false;
        }

        @Override
        public Map.Entry<String, String> next() {
            if (!this.hasNext()) {
                throw new NoSuchElementException();
            }
            final String value = this.listIterator.next();
            assert (this.key != null);
            return new Map.Entry<String, String>(){

                @Override
                public String getKey() {
                    return key;
                }

                @Override
                public String getValue() {
                    return value;
                }

                @Override
                public String setValue(String value2) {
                    throw new UnsupportedOperationException();
                }
            };
        }

        @Override
        public void remove() {
            this.listIterator.remove();
            if (this.value.isEmpty()) {
                this.mapIterator.remove();
            }
            this.queryParamsUpdater.run();
        }
    }

    private static final class ValuesIterator
    implements Iterator<String> {
        private final Iterator<String> listIterator;
        private final Runnable queryParamsUpdater;

        private ValuesIterator(Iterator<String> listIterator, Runnable removalQueryParamsUpdater) {
            this.listIterator = listIterator;
            this.queryParamsUpdater = removalQueryParamsUpdater;
        }

        @Override
        public boolean hasNext() {
            return this.listIterator.hasNext();
        }

        @Override
        public String next() {
            return this.listIterator.next();
        }

        @Override
        public void remove() {
            this.listIterator.remove();
            this.queryParamsUpdater.run();
        }
    }
}

