/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.GracefulAutoCloseable;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.FutureUtils;
import io.servicetalk.http.api.BlockingHttpConnection;
import io.servicetalk.http.api.BlockingStreamingHttpConnection;
import io.servicetalk.http.api.HttpConnectionContext;
import io.servicetalk.http.api.HttpEventKey;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequester;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.StreamingHttpConnection;

public interface HttpConnection
extends HttpRequester,
GracefulAutoCloseable {
    public Single<HttpResponse> request(HttpRequest var1);

    public HttpConnectionContext connectionContext();

    public <T> Publisher<? extends T> transportEventStream(HttpEventKey<T> var1);

    public StreamingHttpConnection asStreamingConnection();

    default public BlockingStreamingHttpConnection asBlockingStreamingConnection() {
        return this.asStreamingConnection().asBlockingStreamingConnection();
    }

    default public BlockingHttpConnection asBlockingConnection() {
        return this.asStreamingConnection().asBlockingConnection();
    }

    @Override
    default public void close() throws Exception {
        FutureUtils.awaitTermination(this.closeAsync().toFuture());
    }

    @Override
    default public void closeGracefully() throws Exception {
        FutureUtils.awaitTermination(this.closeAsyncGracefully().toFuture());
    }
}

