/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.http.api;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.api.internal.SubscribableCompletable;
import io.servicetalk.concurrent.api.internal.SubscribableSingle;
import io.servicetalk.concurrent.internal.ThreadInterruptingCancellable;
import io.servicetalk.http.api.BlockingHttpRequester;
import io.servicetalk.http.api.BlockingStreamingHttpRequest;
import io.servicetalk.http.api.BlockingStreamingHttpRequester;
import io.servicetalk.http.api.BlockingStreamingHttpResponse;
import io.servicetalk.http.api.HttpExecutionStrategy;
import io.servicetalk.http.api.HttpRequest;
import io.servicetalk.http.api.HttpRequester;
import io.servicetalk.http.api.HttpResponse;
import io.servicetalk.http.api.StreamingHttpRequest;
import io.servicetalk.http.api.StreamingHttpRequester;
import io.servicetalk.http.api.StreamingHttpResponse;
import io.servicetalk.utils.internal.PlatformDependent;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;

final class BlockingUtils {
    private BlockingUtils() {
    }

    static Completable blockingToCompletable(final RunnableCheckedException r) {
        return new SubscribableCompletable(){

            @Override
            protected void handleSubscribe(CompletableSource.Subscriber subscriber) {
                ThreadInterruptingCancellable cancellable = new ThreadInterruptingCancellable(Thread.currentThread());
                subscriber.onSubscribe(cancellable);
                try {
                    r.run();
                }
                catch (Throwable cause) {
                    cancellable.setDone(cause);
                    subscriber.onError(cause);
                    return;
                }
                cancellable.setDone();
                subscriber.onComplete();
            }
        };
    }

    static <T> Single<T> blockingToSingle(final SupplierCheckedException<T> supplier) {
        return new SubscribableSingle<T>(){

            @Override
            protected void handleSubscribe(SingleSource.Subscriber<? super T> subscriber) {
                Object response;
                ThreadInterruptingCancellable cancellable = new ThreadInterruptingCancellable(Thread.currentThread());
                subscriber.onSubscribe(cancellable);
                try {
                    response = supplier.get();
                }
                catch (Throwable cause) {
                    cancellable.setDone(cause);
                    subscriber.onError(cause);
                    return;
                }
                cancellable.setDone();
                subscriber.onSuccess(response);
            }
        };
    }

    static <T> T futureGetCancelOnInterrupt(Future<T> future) throws Exception {
        try {
            return future.get();
        }
        catch (InterruptedException e) {
            Thread.currentThread().interrupt();
            future.cancel(false);
            throw e;
        }
        catch (ExecutionException e) {
            return PlatformDependent.throwException(BlockingUtils.executionExceptionCause(e));
        }
    }

    static BlockingStreamingHttpResponse request(StreamingHttpRequester requester, HttpExecutionStrategy strategy, BlockingStreamingHttpRequest request) throws Exception {
        return BlockingUtils.blockingInvocation(requester.request(strategy, request.toStreamingRequest())).toBlockingStreamingResponse();
    }

    static Single<StreamingHttpResponse> request(BlockingHttpRequester requester, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return request.toRequest().flatMap(req -> BlockingUtils.blockingToSingle(() -> requester.request(strategy, (HttpRequest)req))).map(HttpResponse::toStreamingResponse);
    }

    static HttpResponse request(HttpRequester requester, HttpExecutionStrategy strategy, HttpRequest request) throws Exception {
        return BlockingUtils.blockingInvocation(requester.request(strategy, request));
    }

    static HttpResponse request(StreamingHttpRequester requester, HttpExecutionStrategy strategy, HttpRequest request) throws Exception {
        return (HttpResponse)BlockingUtils.blockingInvocation(requester.request(strategy, request.toStreamingRequest()).flatMap(StreamingHttpResponse::toResponse));
    }

    static Single<StreamingHttpResponse> request(BlockingStreamingHttpRequester requester, HttpExecutionStrategy strategy, StreamingHttpRequest request) {
        return BlockingUtils.blockingToSingle(() -> requester.request(strategy, request.toBlockingStreamingRequest()).toStreamingResponse());
    }

    static Single<HttpResponse> request(BlockingHttpRequester requester, HttpExecutionStrategy strategy, HttpRequest request) {
        return BlockingUtils.blockingToSingle(() -> requester.request(strategy, request));
    }

    static <T> T blockingInvocation(Single<T> source) throws Exception {
        try {
            return source.toFuture().get();
        }
        catch (ExecutionException e) {
            return PlatformDependent.throwException(BlockingUtils.executionExceptionCause(e));
        }
    }

    static void blockingInvocation(Completable source) throws Exception {
        try {
            source.toFuture().get();
        }
        catch (ExecutionException e) {
            PlatformDependent.throwException(BlockingUtils.executionExceptionCause(e));
        }
    }

    private static Throwable executionExceptionCause(ExecutionException original) {
        return original.getCause() != null ? original.getCause() : original;
    }

    static interface SupplierCheckedException<T> {
        public T get() throws Exception;
    }

    static interface RunnableCheckedException {
        public void run() throws Exception;
    }
}

