/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.encoding.api;

import io.servicetalk.encoding.api.ContentCodec;
import io.servicetalk.encoding.api.ContentCodecBuilder;
import io.servicetalk.encoding.api.DeflateContentCodec;
import io.servicetalk.encoding.api.GzipContentCodec;

abstract class DefaultContentCodecBuilder
implements ContentCodecBuilder {
    private static final int CHUNK_SIZE = 1024;
    private static final int DEFAULT_MAX_ALLOWED_DECOMPRESSED_PAYLOAD = 0x1000000;
    private int maxAllowedPayloadSize = 0x1000000;

    DefaultContentCodecBuilder() {
    }

    protected int maxAllowedPayloadSize() {
        return this.maxAllowedPayloadSize;
    }

    @Override
    public ContentCodecBuilder setMaxAllowedPayloadSize(int maxAllowedPayloadSize) {
        if (maxAllowedPayloadSize <= 0) {
            throw new IllegalArgumentException("maxAllowedPayloadSize: " + maxAllowedPayloadSize + " (expected > 0)");
        }
        this.maxAllowedPayloadSize = maxAllowedPayloadSize;
        return this;
    }

    static final class DeflateContentCodecBuilder
    extends DefaultContentCodecBuilder {
        DeflateContentCodecBuilder() {
        }

        @Override
        public ContentCodec build() {
            return new DeflateContentCodec(1024, this.maxAllowedPayloadSize());
        }
    }

    static final class GzipContentCodecBuilder
    extends DefaultContentCodecBuilder {
        GzipContentCodecBuilder() {
        }

        @Override
        public ContentCodec build() {
            return new GzipContentCodec(1024, this.maxAllowedPayloadSize());
        }
    }
}

