/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.internal;

import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import java.util.Objects;
import javax.annotation.Nullable;

public final class TerminalNotification {
    private static final TerminalNotification COMPLETE = new TerminalNotification();
    @Nullable
    private final Throwable cause;

    private TerminalNotification(Throwable cause) {
        this.cause = Objects.requireNonNull(cause);
    }

    private TerminalNotification() {
        this.cause = null;
    }

    public void terminate(PublisherSource.Subscriber<?> subscriber) {
        if (this == COMPLETE) {
            subscriber.onComplete();
        } else {
            subscriber.onError(this.cause);
        }
    }

    public void terminate(PublisherSource.Subscriber<?> subscriber, Throwable additionalCause) {
        if (this == COMPLETE) {
            subscriber.onError(additionalCause);
        } else {
            assert (this.cause != null);
            this.cause.addSuppressed(additionalCause);
            subscriber.onError(this.cause);
        }
    }

    public void terminate(CompletableSource.Subscriber subscriber, Throwable additionalCause) {
        if (this == COMPLETE) {
            subscriber.onError(additionalCause);
        } else {
            assert (this.cause != null);
            this.cause.addSuppressed(additionalCause);
            subscriber.onError(this.cause);
        }
    }

    public void terminate(CompletableSource.Subscriber subscriber) {
        if (this == COMPLETE) {
            subscriber.onComplete();
        } else {
            assert (this.cause != null);
            subscriber.onError(this.cause);
        }
    }

    @Nullable
    public Throwable cause() {
        return this.cause;
    }

    public static TerminalNotification error(Throwable cause) {
        return new TerminalNotification(cause);
    }

    public static TerminalNotification complete() {
        return COMPLETE;
    }

    public String toString() {
        return "TerminalNotification{" + (this.cause == null ? "COMPLETE" : this.cause) + "}";
    }
}

