/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.api.AbstractSynchronousPublisherOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.internal.ConcurrentSubscription;
import io.servicetalk.concurrent.internal.ConcurrentTerminalSubscriber;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class TakeUntilPublisher<T>
extends AbstractSynchronousPublisherOperator<T, T> {
    private final Completable until;

    TakeUntilPublisher(Publisher<T> original, Completable until, Executor executor) {
        super(original, executor);
        this.until = Objects.requireNonNull(until);
    }

    @Override
    public PublisherSource.Subscriber<? super T> apply(PublisherSource.Subscriber<? super T> subscriber) {
        return new TakeUntilSubscriber<T>(subscriber, this.until);
    }

    private static final class TakeUntilSubscription
    extends ConcurrentSubscription {
        private final Cancellable cancellable;

        protected TakeUntilSubscription(PublisherSource.Subscription subscription, Cancellable cancellable) {
            super(subscription);
            this.cancellable = cancellable;
        }

        @Override
        public void cancel() {
            try {
                super.cancel();
            }
            finally {
                this.cancellable.cancel();
            }
        }

        void superCancel() {
            super.cancel();
        }
    }

    private static final class TakeUntilSubscriber<T>
    implements PublisherSource.Subscriber<T> {
        private static final AtomicReferenceFieldUpdater<TakeUntilSubscriber, Cancellable> untilCancellableUpdater = AtomicReferenceFieldUpdater.newUpdater(TakeUntilSubscriber.class, Cancellable.class, "untilCancellable");
        @Nullable
        private volatile TakeUntilSubscription downstreamSubscription;
        @Nullable
        private volatile Cancellable untilCancellable;
        private final ConcurrentTerminalSubscriber<? super T> subscriber;
        private final Completable until;

        TakeUntilSubscriber(PublisherSource.Subscriber<? super T> subscriber, Completable until) {
            this.subscriber = new ConcurrentTerminalSubscriber<T>(subscriber, false);
            this.until = until;
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription s) {
            TakeUntilSubscription takeSubscription;
            if (!SubscriberUtils.checkDuplicateSubscription(this.downstreamSubscription, s)) {
                return;
            }
            this.downstreamSubscription = takeSubscription = new TakeUntilSubscription(s, this::cancelUntil);
            this.subscriber.onSubscribe(takeSubscription);
            this.until.subscribeInternal(new CompletableSource.Subscriber(){

                @Override
                public void onSubscribe(Cancellable cancellable) {
                    if (!untilCancellableUpdater.compareAndSet(this, null, cancellable)) {
                        cancellable.cancel();
                    }
                }

                @Override
                public void onComplete() {
                    if (subscriber.processOnComplete()) {
                        this.cancelDownstreamSubscription();
                    }
                }

                @Override
                public void onError(Throwable t) {
                    if (subscriber.processOnError(t)) {
                        this.cancelDownstreamSubscription();
                    }
                }

                private void cancelDownstreamSubscription() {
                    TakeUntilSubscription s = downstreamSubscription;
                    assert (s != null);
                    s.superCancel();
                }
            });
        }

        @Override
        public void onNext(T t) {
            this.subscriber.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            if (this.subscriber.processOnError(t)) {
                this.cancelUntil();
            }
        }

        @Override
        public void onComplete() {
            if (this.subscriber.processOnComplete()) {
                this.cancelUntil();
            }
        }

        private void cancelUntil() {
            Cancellable untilCancellable = untilCancellableUpdater.getAndSet(this, Cancellable.IGNORE_CANCEL);
            if (untilCancellable != null) {
                untilCancellable.cancel();
            }
        }
    }
}

