/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.PublisherSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribePublisher;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.DelayedCancellableThenSubscription;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Publisher;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SignalOffloader;
import io.servicetalk.concurrent.internal.SubscriberUtils;
import java.util.concurrent.atomic.AtomicReferenceFieldUpdater;
import javax.annotation.Nullable;

final class SingleConcatWithPublisher<T>
extends AbstractNoHandleSubscribePublisher<T> {
    private final Single<? extends T> original;
    private final Publisher<? extends T> next;

    SingleConcatWithPublisher(Single<? extends T> original, Publisher<? extends T> next, Executor executor) {
        super(executor);
        this.original = original;
        this.next = next;
    }

    @Override
    void handleSubscribe(PublisherSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ConcatSubscriber<T>(subscriber, this.next), signalOffloader, contextMap, contextProvider);
    }

    private static final class ConcatSubscriber<T>
    extends DelayedCancellableThenSubscription
    implements SingleSource.Subscriber<T>,
    PublisherSource.Subscriber<T> {
        private static final Object INITIAL = new Object();
        private static final Object REQUESTED = new Object();
        private static final Object CANCELLED = new Object();
        private static final AtomicReferenceFieldUpdater<ConcatSubscriber, Object> mayBeResultUpdater = AtomicReferenceFieldUpdater.newUpdater(ConcatSubscriber.class, Object.class, "mayBeResult");
        private final PublisherSource.Subscriber<? super T> target;
        private final Publisher<? extends T> next;
        @Nullable
        private volatile Object mayBeResult = INITIAL;

        ConcatSubscriber(PublisherSource.Subscriber<? super T> subscriber, Publisher<? extends T> next) {
            this.target = subscriber;
            this.next = next;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.delayedCancellable(cancellable);
            this.target.onSubscribe(this);
        }

        @Override
        public void onSuccess(@Nullable T result) {
            Object oldValue;
            do {
                if ((oldValue = this.mayBeResult) != REQUESTED) continue;
                this.emitSingleSuccessToTarget(result);
                break;
            } while (oldValue != CANCELLED && !mayBeResultUpdater.compareAndSet(this, INITIAL, result));
        }

        @Override
        public void onComplete() {
            this.target.onComplete();
        }

        @Override
        public void onSubscribe(PublisherSource.Subscription subscription) {
            this.delayedSubscription(subscription);
        }

        @Override
        public void onNext(@Nullable T t) {
            this.target.onNext(t);
        }

        @Override
        public void onError(Throwable t) {
            this.target.onError(t);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void request(long n) {
            block6: {
                Object oldVal;
                do {
                    if ((oldVal = this.mayBeResult) == REQUESTED || oldVal == CANCELLED) {
                        super.request(n);
                        break block6;
                    }
                    if (SubscriberUtils.isRequestNValid(n)) continue;
                    this.mayBeResult = CANCELLED;
                    try {
                        this.target.onError(SubscriberUtils.newExceptionForInvalidRequestN(n));
                        break block6;
                    }
                    finally {
                        super.cancel();
                    }
                } while (!mayBeResultUpdater.compareAndSet(this, oldVal, REQUESTED));
                if (oldVal != INITIAL) {
                    Object tVal = oldVal;
                    this.emitSingleSuccessToTarget(tVal);
                }
                if (n == 1L) break block6;
                super.request(n - 1L);
            }
        }

        @Override
        public void cancel() {
            this.mayBeResult = CANCELLED;
            super.cancel();
        }

        private void emitSingleSuccessToTarget(@Nullable T result) {
            this.target.onNext(result);
            this.next.subscribeInternal(this);
        }
    }
}

