/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.BiIntFunction;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.RetrySingle;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import javax.annotation.Nullable;

final class RetryWhenSingle<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Single<T> original;
    private final BiIntFunction<Throwable, ? extends Completable> shouldRetry;

    RetryWhenSingle(Single<T> original, BiIntFunction<Throwable, ? extends Completable> shouldRetry, Executor executor) {
        super(executor);
        this.original = original;
        this.shouldRetry = shouldRetry;
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new RetrySubscriber<T>(new SequentialCancellable(), 0, subscriber, contextMap, contextProvider, this, signalOffloader), signalOffloader, contextMap, contextProvider);
    }

    private static final class RetrySubscriber<T>
    extends RetrySingle.AbstractRetrySubscriber<T> {
        private final SequentialCancellable retrySignalCancellable;
        private final RetryWhenSingle<T> retrySingle;
        private final SignalOffloader signalOffloader;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;

        RetrySubscriber(SequentialCancellable cancellable, int redoCount, SingleSource.Subscriber<? super T> subscriber, AsyncContextMap contextMap, AsyncContextProvider contextProvider, RetryWhenSingle<T> retrySingle, SignalOffloader signalOffloader) {
            super(cancellable, subscriber, redoCount);
            this.retrySingle = retrySingle;
            this.retrySignalCancellable = new SequentialCancellable();
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
            this.signalOffloader = signalOffloader;
        }

        @Override
        Cancellable decorate(Cancellable cancellable) {
            return () -> {
                try {
                    this.retrySignalCancellable.cancel();
                }
                finally {
                    cancellable.cancel();
                }
            };
        }

        @Override
        public void onSuccess(@Nullable T t) {
            this.target.onSuccess(t);
        }

        @Override
        public void onError(Throwable t) {
            Completable retryDecider;
            try {
                retryDecider = (Completable)Objects.requireNonNull(((RetryWhenSingle)this.retrySingle).shouldRetry.apply(this.retryCount + 1, t));
            }
            catch (Throwable cause) {
                cause.addSuppressed(t);
                this.target.onError(cause);
                return;
            }
            retryDecider.subscribeInternal(new CompletableSource.Subscriber(){

                @Override
                public void onSubscribe(Cancellable completableCancellable) {
                    retrySignalCancellable.nextCancellable(completableCancellable);
                }

                @Override
                public void onComplete() {
                    retrySingle.original.delegateSubscribe(new RetrySubscriber(sequentialCancellable, retryCount + 1, target, contextMap.copy(), contextProvider, retrySingle, signalOffloader), signalOffloader, contextMap, contextProvider);
                }

                @Override
                public void onError(Throwable t) {
                    target.onError(t);
                }
            });
        }
    }
}

