/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractNoHandleSubscribeSingle;
import io.servicetalk.concurrent.api.AsyncContextMap;
import io.servicetalk.concurrent.api.AsyncContextProvider;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import io.servicetalk.concurrent.internal.SequentialCancellable;
import io.servicetalk.concurrent.internal.SignalOffloader;
import java.util.Objects;
import java.util.function.Function;
import javax.annotation.Nullable;

final class ResumeSingle<T>
extends AbstractNoHandleSubscribeSingle<T> {
    private final Single<T> original;
    private final Function<Throwable, ? extends Single<? extends T>> nextFactory;

    ResumeSingle(Single<T> original, Function<Throwable, ? extends Single<? extends T>> nextFactory, Executor executor) {
        super(executor);
        this.original = original;
        this.nextFactory = Objects.requireNonNull(nextFactory);
    }

    @Override
    void handleSubscribe(SingleSource.Subscriber<? super T> subscriber, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
        this.original.delegateSubscribe(new ResumeSubscriber<T>(subscriber, this.nextFactory, signalOffloader, contextMap, contextProvider), signalOffloader, contextMap, contextProvider);
    }

    private static final class ResumeSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> subscriber;
        private final SignalOffloader signalOffloader;
        private final AsyncContextMap contextMap;
        private final AsyncContextProvider contextProvider;
        @Nullable
        private SequentialCancellable sequentialCancellable;
        @Nullable
        private Function<Throwable, ? extends Single<? extends T>> nextFactory;

        ResumeSubscriber(SingleSource.Subscriber<? super T> subscriber, Function<Throwable, ? extends Single<? extends T>> nextFactory, SignalOffloader signalOffloader, AsyncContextMap contextMap, AsyncContextProvider contextProvider) {
            this.subscriber = subscriber;
            this.nextFactory = nextFactory;
            this.signalOffloader = signalOffloader;
            this.contextMap = contextMap;
            this.contextProvider = contextProvider;
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            if (this.sequentialCancellable == null) {
                this.sequentialCancellable = new SequentialCancellable(cancellable);
                this.subscriber.onSubscribe(this.sequentialCancellable);
            } else {
                this.nextFactory = null;
                this.sequentialCancellable.nextCancellable(cancellable);
            }
        }

        @Override
        public void onSuccess(@Nullable T result) {
            this.subscriber.onSuccess(result);
        }

        @Override
        public void onError(Throwable throwable) {
            Single next;
            if (this.nextFactory == null) {
                this.subscriber.onError(throwable);
                return;
            }
            try {
                next = Objects.requireNonNull(this.nextFactory.apply(throwable));
            }
            catch (Throwable t) {
                t.addSuppressed(throwable);
                this.subscriber.onError(t);
                return;
            }
            SingleSource.Subscriber offloadedSubscriber = this.signalOffloader.offloadSubscriber(this.contextProvider.wrapSingleSubscriber(this, this.contextMap));
            next.subscribeInternal(offloadedSubscriber);
        }
    }
}

