/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.api.AsyncCloseable;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.CompositeCloseable;
import io.servicetalk.concurrent.internal.FutureUtils;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

final class DefaultCompositeCloseable
implements CompositeCloseable {
    private static final Logger LOGGER = LoggerFactory.getLogger(DefaultCompositeCloseable.class);
    private Completable closeAsync = Completable.completed();
    private Completable closeAsyncGracefully = Completable.completed();

    DefaultCompositeCloseable() {
    }

    @Override
    public <T extends AsyncCloseable> T merge(T closeable) {
        this.mergeCloseableDelayError(closeable);
        return closeable;
    }

    @Override
    public CompositeCloseable mergeAll(AsyncCloseable ... asyncCloseables) {
        this.mergeCloseableDelayError(Arrays.asList(asyncCloseables));
        return this;
    }

    @Override
    public CompositeCloseable mergeAll(Iterable<? extends AsyncCloseable> asyncCloseables) {
        this.mergeCloseableDelayError(StreamSupport.stream(asyncCloseables.spliterator(), false).collect(Collectors.toList()));
        return this;
    }

    @Override
    public <T extends AsyncCloseable> T append(T closeable) {
        this.concatCloseableDelayError(closeable);
        return closeable;
    }

    @Override
    public CompositeCloseable appendAll(AsyncCloseable ... asyncCloseables) {
        for (AsyncCloseable closeable : asyncCloseables) {
            this.concatCloseableDelayError(closeable);
        }
        return this;
    }

    @Override
    public CompositeCloseable appendAll(Iterable<? extends AsyncCloseable> asyncCloseables) {
        asyncCloseables.forEach(this::concatCloseableDelayError);
        return this;
    }

    @Override
    public <T extends AsyncCloseable> T prepend(T closeable) {
        this.prependCloseableDelayError(closeable);
        return closeable;
    }

    @Override
    public CompositeCloseable prependAll(AsyncCloseable ... asyncCloseables) {
        for (AsyncCloseable closeable : asyncCloseables) {
            this.prependCloseableDelayError(closeable);
        }
        return this;
    }

    @Override
    public CompositeCloseable prependAll(Iterable<? extends AsyncCloseable> asyncCloseables) {
        asyncCloseables.forEach(this::prependCloseableDelayError);
        return this;
    }

    @Override
    public Completable closeAsync() {
        return this.closeAsync;
    }

    @Override
    public Completable closeAsyncGracefully() {
        return this.closeAsyncGracefully;
    }

    @Override
    public void close() {
        FutureUtils.awaitTermination(this.closeAsync().toFuture());
    }

    @Override
    public void closeGracefully() {
        FutureUtils.awaitTermination(this.closeAsyncGracefully().toFuture());
    }

    private void mergeCloseableDelayError(AsyncCloseable closeable) {
        this.closeAsync = this.closeAsync.mergeDelayError(closeable.closeAsync());
        this.closeAsyncGracefully = this.closeAsyncGracefully.mergeDelayError(closeable.closeAsyncGracefully());
    }

    private void mergeCloseableDelayError(List<AsyncCloseable> closeables) {
        this.closeAsync = this.closeAsync.mergeDelayError(closeables.stream().map(AsyncCloseable::closeAsync).collect(Collectors.toList()));
        this.closeAsyncGracefully = this.closeAsyncGracefully.mergeDelayError(closeables.stream().map(AsyncCloseable::closeAsyncGracefully).collect(Collectors.toList()));
    }

    private void concatCloseableDelayError(AsyncCloseable closeable) {
        this.closeAsync = this.closeAsync.concat(closeable.closeAsync().onErrorResume(th -> {
            LOGGER.debug("Ignored failure to close {}.", (Object)closeable, th);
            return Completable.completed();
        }));
        this.closeAsyncGracefully = this.closeAsyncGracefully.concat(closeable.closeAsyncGracefully().onErrorResume(th -> {
            LOGGER.debug("Ignored failure to close {}.", (Object)closeable, th);
            return Completable.completed();
        }));
    }

    private void prependCloseableDelayError(AsyncCloseable closeable) {
        this.closeAsync = closeable.closeAsync().onErrorResume(th -> {
            LOGGER.debug("Ignored failure to close {}.", (Object)closeable, th);
            return Completable.completed();
        }).concat(this.closeAsync);
        this.closeAsyncGracefully = closeable.closeAsyncGracefully().onErrorResume(th -> {
            LOGGER.debug("Ignored failure to close {}.", (Object)closeable, th);
            return Completable.completed();
        }).concat(this.closeAsyncGracefully);
    }
}

