/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.CompletableSource;
import io.servicetalk.concurrent.api.AbstractSynchronousCompletableOperator;
import io.servicetalk.concurrent.api.Completable;
import io.servicetalk.concurrent.api.Executor;
import java.util.Objects;
import java.util.function.Supplier;

final class BeforeSubscriberCompletable
extends AbstractSynchronousCompletableOperator {
    private final Supplier<? extends CompletableSource.Subscriber> subscriberSupplier;

    BeforeSubscriberCompletable(Completable original, Supplier<? extends CompletableSource.Subscriber> subscriberSupplier, Executor executor) {
        super(original, executor);
        this.subscriberSupplier = Objects.requireNonNull(subscriberSupplier);
    }

    @Override
    public CompletableSource.Subscriber apply(CompletableSource.Subscriber subscriber) {
        return new BeforeSubscriberCompletableSubscriber(subscriber, this.subscriberSupplier.get());
    }

    private static final class BeforeSubscriberCompletableSubscriber
    implements CompletableSource.Subscriber {
        private final CompletableSource.Subscriber original;
        private final CompletableSource.Subscriber subscriber;

        BeforeSubscriberCompletableSubscriber(CompletableSource.Subscriber original, CompletableSource.Subscriber subscriber) {
            this.original = original;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.subscriber.onSubscribe(cancellable);
            this.original.onSubscribe(cancellable);
        }

        @Override
        public void onComplete() {
            try {
                this.subscriber.onComplete();
            }
            catch (Throwable cause) {
                this.original.onError(cause);
                return;
            }
            this.original.onComplete();
        }

        @Override
        public void onError(Throwable t) {
            try {
                this.subscriber.onError(t);
            }
            catch (Throwable cause) {
                t.addSuppressed(cause);
                this.original.onError(t);
                return;
            }
            this.original.onError(t);
        }
    }
}

