/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.concurrent.api;

import io.servicetalk.concurrent.Cancellable;
import io.servicetalk.concurrent.SingleSource;
import io.servicetalk.concurrent.api.AbstractSynchronousSingleOperator;
import io.servicetalk.concurrent.api.Executor;
import io.servicetalk.concurrent.api.Single;
import java.util.Objects;
import java.util.function.Supplier;

final class AfterSubscriberSingle<T>
extends AbstractSynchronousSingleOperator<T, T> {
    private final Supplier<? extends SingleSource.Subscriber<? super T>> subscriberSupplier;

    AfterSubscriberSingle(Single<T> original, Supplier<? extends SingleSource.Subscriber<? super T>> subscriberSupplier, Executor executor) {
        super(original, executor);
        this.subscriberSupplier = Objects.requireNonNull(subscriberSupplier);
    }

    @Override
    public SingleSource.Subscriber<? super T> apply(SingleSource.Subscriber<? super T> subscriber) {
        return new AfterSubscriberSingleSubscriber<T>(subscriber, this.subscriberSupplier.get());
    }

    private static final class AfterSubscriberSingleSubscriber<T>
    implements SingleSource.Subscriber<T> {
        private final SingleSource.Subscriber<? super T> original;
        private final SingleSource.Subscriber<? super T> subscriber;

        AfterSubscriberSingleSubscriber(SingleSource.Subscriber<? super T> original, SingleSource.Subscriber<? super T> subscriber) {
            this.original = original;
            this.subscriber = Objects.requireNonNull(subscriber);
        }

        @Override
        public void onSubscribe(Cancellable cancellable) {
            this.original.onSubscribe(cancellable);
            this.subscriber.onSubscribe(cancellable);
        }

        @Override
        public void onSuccess(T value) {
            try {
                this.original.onSuccess(value);
            }
            finally {
                this.subscriber.onSuccess(value);
            }
        }

        @Override
        public void onError(Throwable t) {
            try {
                this.original.onError(t);
            }
            finally {
                this.subscriber.onError(t);
            }
        }
    }
}

