/*
 * Decompiled with CFR 0.152.
 */
package io.servicetalk.client.api.internal;

import io.servicetalk.client.api.DefaultServiceDiscovererEvent;
import io.servicetalk.client.api.ServiceDiscovererEvent;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.RandomAccess;
import javax.annotation.Nullable;

public final class ServiceDiscovererUtils {
    private ServiceDiscovererUtils() {
    }

    @Nullable
    public static <T> List<ServiceDiscovererEvent<T>> calculateDifference(List<? extends T> currentActiveAddresses, List<? extends T> newActiveAddresses, Comparator<T> comparator, @Nullable TwoIntsConsumer reporter) {
        newActiveAddresses.sort(comparator);
        List<ServiceDiscovererEvent<T>> availableEvents = ServiceDiscovererUtils.relativeComplement(true, currentActiveAddresses, newActiveAddresses, comparator, null);
        int nAvailable = availableEvents == null ? 0 : availableEvents.size();
        List<ServiceDiscovererEvent<T>> allEvents = ServiceDiscovererUtils.relativeComplement(false, newActiveAddresses, currentActiveAddresses, comparator, availableEvents);
        ServiceDiscovererUtils.reportEvents(reporter, allEvents, nAvailable);
        return allEvents;
    }

    private static <T> void reportEvents(@Nullable TwoIntsConsumer reporter, @Nullable List<ServiceDiscovererEvent<T>> allEvents, int nAvailable) {
        if (reporter == null) {
            return;
        }
        if (allEvents == null) {
            reporter.accept(0, 0);
            return;
        }
        reporter.accept(nAvailable, allEvents.size() - nAvailable);
    }

    @Nullable
    private static <T> List<ServiceDiscovererEvent<T>> relativeComplement(boolean available, List<? extends T> sortedA, List<? extends T> sortedB, Comparator<T> comparator, @Nullable List<ServiceDiscovererEvent<T>> result) {
        if (sortedB instanceof RandomAccess) {
            for (int i = 0; i < sortedB.size(); ++i) {
                T valueB = sortedB.get(i);
                if (Collections.binarySearch(sortedA, valueB, comparator) >= 0) continue;
                if (result == null) {
                    result = new ArrayList<ServiceDiscovererEvent<T>>(4);
                    result.add(new DefaultServiceDiscovererEvent<T>(valueB, available));
                    continue;
                }
                if (comparator.compare(valueB, result.get(result.size() - 1).address()) == 0) continue;
                result.add(new DefaultServiceDiscovererEvent<T>(valueB, available));
            }
        } else {
            for (T valueB : sortedB) {
                if (Collections.binarySearch(sortedA, valueB, comparator) >= 0) continue;
                if (result == null) {
                    result = new ArrayList<ServiceDiscovererEvent<T>>(4);
                    result.add(new DefaultServiceDiscovererEvent<T>(valueB, available));
                    continue;
                }
                if (comparator.compare(valueB, result.get(result.size() - 1).address()) == 0) continue;
                result.add(new DefaultServiceDiscovererEvent<T>(valueB, available));
            }
        }
        return result;
    }

    @FunctionalInterface
    public static interface TwoIntsConsumer {
        public void accept(int var1, int var2);
    }
}

