/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.trace.jsonbin;

import com.fasterxml.jackson.core.JsonProcessingException;
import com.fasterxml.jackson.databind.ObjectMapper;
import io.scalecube.trace.jsonbin.JsonbinRequest;
import io.scalecube.trace.jsonbin.JsonbinResponse;
import java.io.IOException;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.HttpClient;
import org.rapidoid.http.HttpReq;
import org.rapidoid.http.HttpResp;
import reactor.core.publisher.Mono;

public class JsonbinClient {
    private static final String APPLICATION_JSON = "application/json";
    private final HttpClient client;
    private final ObjectMapper mapper;

    public JsonbinClient(ObjectMapper mapper) {
        this.mapper = mapper;
        this.client = HTTP.client().reuseConnections(true).keepAlive(true);
    }

    public <R> Mono<JsonbinResponse> get(JsonbinRequest<R> request) throws IOException {
        return Mono.create(sink -> this.client.executeRequest(this.options(request).get(request.url()).contentType(APPLICATION_JSON), (Callback)new Callback<HttpResp>(){

            public void onDone(HttpResp result, Throwable error) throws Exception {
                sink.success(JsonbinClient.this.mapper.readValue(result.bodyBytes(), JsonbinResponse.class));
            }
        }));
    }

    public <R> Mono<JsonbinResponse> put(JsonbinRequest<R> request) {
        return Mono.create(sink -> {
            try {
                this.client.executeRequest(this.options(request).put(request.url()).contentType(APPLICATION_JSON).body(this.mapper.writeValueAsBytes(request.body())), (Callback)new Callback<HttpResp>(){

                    public void onDone(HttpResp result, Throwable error) throws Exception {
                        sink.success(JsonbinClient.this.mapper.readValue(result.bodyBytes(), JsonbinResponse.class));
                    }
                });
            }
            catch (JsonProcessingException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public <R> Mono<JsonbinResponse> post(JsonbinRequest<R> request) {
        return Mono.create(sink -> {
            try {
                this.client.executeRequest(this.options(request).post(request.url()).contentType(APPLICATION_JSON).body(this.mapper.writeValueAsBytes(request.body())), (Callback)new Callback<HttpResp>(){

                    public void onDone(HttpResp result, Throwable error) throws Exception {
                        sink.success(JsonbinClient.this.mapper.readValue(result.bodyBytes(), JsonbinResponse.class));
                    }
                });
            }
            catch (JsonProcessingException e) {
                sink.error((Throwable)e);
            }
        });
    }

    private HttpReq options(JsonbinRequest request) {
        HttpReq http = new HttpReq(this.client);
        if (request.secret() != null) {
            http = http.header("secret-key", request.secret());
        }
        if (request.collectionId() != null) {
            http = http.header("collection-id", request.collectionId());
        }
        if (!request.versioning()) {
            http = http.header("versioning", "false");
        }
        if (request.isPrivate()) {
            http = http.header("private", "true");
        }
        return http;
    }
}

