/*
 * Decompiled with CFR 0.152.
 */
package io.scalecube.trace;

import com.fasterxml.jackson.annotation.JsonAutoDetect;
import com.fasterxml.jackson.annotation.JsonInclude;
import com.fasterxml.jackson.annotation.PropertyAccessor;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.JsonNode;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.SerializationFeature;
import com.fasterxml.jackson.databind.node.ArrayNode;
import com.fasterxml.jackson.databind.node.ObjectNode;
import io.scalecube.trace.TraceData;
import io.scalecube.trace.jsonbin.JsonbinClient;
import io.scalecube.trace.jsonbin.JsonbinRequest;
import io.scalecube.trace.jsonbin.JsonbinResponse;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.time.Duration;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.LongAdder;
import reactor.core.publisher.Flux;
import reactor.core.publisher.Mono;

public class TraceReporter {
    static ObjectMapper mapper;
    static JsonGenerator generator;
    private static final String URL_API_JSONBIN_IO = "https://api.jsonbin.io/b/";
    private static String DEFAULT_TRACES_FOLDER;
    private static String DEFAULT_CHARTS_FOLDER;
    private static String template;
    private final ScheduledExecutorService scheduler;
    private final ConcurrentMap<String, TraceData<Object, Object>> traces = new ConcurrentHashMap<String, TraceData<Object, Object>>();
    private final ConcurrentMap<String, LongAdder> xadder = new ConcurrentHashMap<String, LongAdder>();
    private final ConcurrentMap<String, LongAdder> yadder = new ConcurrentHashMap<String, LongAdder>();

    private static ObjectMapper initMapper() {
        ObjectMapper mapper = new ObjectMapper();
        mapper.configure(DeserializationFeature.FAIL_ON_UNKNOWN_PROPERTIES, false);
        mapper.configure(SerializationFeature.FAIL_ON_EMPTY_BEANS, false);
        mapper.configure(DeserializationFeature.READ_UNKNOWN_ENUM_VALUES_AS_NULL, true);
        mapper.configure(SerializationFeature.WRITE_DATES_AS_TIMESTAMPS, false);
        mapper.configure(SerializationFeature.WRITE_ENUMS_USING_TO_STRING, true);
        mapper.setVisibility(PropertyAccessor.ALL, JsonAutoDetect.Visibility.ANY);
        mapper.setSerializationInclusion(JsonInclude.Include.NON_NULL);
        return mapper;
    }

    public String tracesEnv() {
        return TraceReporter.getenvOrDefault("TRACES_FOLDER", DEFAULT_TRACES_FOLDER);
    }

    public String chartsEnv() {
        return TraceReporter.getenvOrDefault("CHARTS_FOLDER", DEFAULT_CHARTS_FOLDER);
    }

    public String teplateFileEnv() {
        return TraceReporter.getenvOrDefault("CHART_TEMPLATE", template);
    }

    public TraceReporter() {
        this.scheduler = Executors.newScheduledThreadPool(1);
        try {
            mapper = TraceReporter.initMapper();
        }
        catch (Exception ex) {
            System.err.println(ex);
        }
    }

    public <X, Y> TraceData<X, Y> trace(String name) {
        return this.traces.computeIfAbsent(name, c -> new TraceData((String)c));
    }

    public <X> void addY(String name, X value) {
        this.xadder(name).increment();
        this.trace(name).xaxis().add(this.xadder(name).longValue());
        this.trace(name).yaxis().add(value);
    }

    public <Y> void addX(String name, Y value) {
        this.yadder(name).increment();
        this.trace(name).yaxis().add(this.yadder(name).longValue());
        this.trace(name).xaxis().add(value);
    }

    public Mono<Void> dumpToFile(String fullName, Object json) {
        try {
            return this.dumpTo(new FileOutputStream(fullName), json);
        }
        catch (FileNotFoundException e) {
            return Mono.error((Throwable)e);
        }
    }

    public Mono<Void> dumpToFile(String folder, String file, Object json) {
        new File(folder).mkdir();
        return this.dumpToFile(folder + file, json);
    }

    public Mono<Void> dumpTo(OutputStream output, Object json) {
        return Mono.create(sink -> {
            try {
                generator = mapper.getFactory().createGenerator(output);
                generator.writeObject(json);
                output.close();
                sink.success();
            }
            catch (IOException e) {
                sink.error((Throwable)e);
            }
        });
    }

    public Mono<Void> dumpTo(String folder) {
        return Flux.fromStream(this.traces.entrySet().stream()).flatMap(m -> this.dumpToFile(folder, (String)m.getKey(), m.getValue())).then();
    }

    public Flux<JsonbinResponse> sendToJsonbin() {
        return this.sendToJsonbin(null, null);
    }

    public Mono<JsonbinResponse> sendToJsonbin(Object data) {
        return this.sendToJsonbin(null, null, data);
    }

    public Flux<JsonbinResponse> sendToJsonbin(String secret, String collectionId) {
        JsonbinClient client = new JsonbinClient(mapper);
        JsonbinRequest.Builder<JsonbinResponse> b = JsonbinRequest.builder().url("https://api.jsonbin.io/b").responseType(JsonbinResponse.class);
        if (secret != null) {
            b.secret(secret);
        }
        if (collectionId != null) {
            b.collection(collectionId);
        }
        return Flux.fromStream(this.traces.values().stream()).flatMap(value -> client.post(b.body((JsonbinResponse)value).build()));
    }

    public Mono<JsonbinResponse> sendToJsonbin(String secret, String collectionId, Object body) {
        JsonbinClient client = new JsonbinClient(mapper);
        JsonbinRequest.Builder<JsonbinResponse> b = JsonbinRequest.builder().url("https://api.jsonbin.io/b").responseType(JsonbinResponse.class);
        if (secret != null) {
            b.secret(secret);
        }
        if (collectionId != null) {
            b.collection(collectionId);
        }
        return client.post(b.body((JsonbinResponse)body).build());
    }

    public ScheduledFuture<?> scheduleDumpTo(Duration duration, String folder) {
        return this.scheduler.scheduleAtFixedRate(() -> this.dumpTo(folder), duration.toMillis(), duration.toMillis(), TimeUnit.MILLISECONDS);
    }

    private LongAdder xadder(String name) {
        return this.xadder.computeIfAbsent(name, c -> new LongAdder());
    }

    private LongAdder yadder(String name) {
        return this.yadder.computeIfAbsent(name, c -> new LongAdder());
    }

    public Mono<Void> createChart(String tracesFolder, String chartsFolder, String chartTemplate) throws Exception {
        return Mono.create(sink -> {
            File inDir = new File(tracesFolder);
            File templateFile = new File(chartTemplate);
            if (this.containsFiles(inDir)) {
                try {
                    JsonNode root = mapper.readTree(templateFile);
                    this.setTraces(root, inDir.list());
                    this.sendToJsonbin(root).subscribe(consumer -> {
                        this.dumpToFile(chartsFolder, consumer.id(), consumer.data()).subscribe();
                        System.out.println(URL_API_JSONBIN_IO + consumer.id());
                        sink.success();
                    });
                }
                catch (Exception e) {
                    sink.error((Throwable)e);
                }
            } else {
                System.out.println("no files are found in" + tracesFolder);
                sink.error((Throwable)new Exception());
            }
        });
    }

    private boolean containsFiles(File inDir) {
        return inDir.list() != null && inDir.list().length > 0;
    }

    private void setTraces(JsonNode root, String[] listTraces) {
        ArrayNode traces = mapper.createArrayNode();
        for (String file : listTraces) {
            traces.add(URL_API_JSONBIN_IO + file);
        }
        ((ObjectNode)root).put("traces", (JsonNode)traces);
        root.path("traces");
    }

    private static String getenvOrDefault(String name, String orDefault) {
        if (System.getenv(name) != null) {
            return System.getenv(name);
        }
        return orDefault;
    }

    static {
        DEFAULT_TRACES_FOLDER = "./target/traces/";
        DEFAULT_CHARTS_FOLDER = "./target/charts/";
        template = "./src/main/resources/chart_template.json";
    }
}

