/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.writable;

import java.io.OutputStream;
import java.util.Arrays;
import org.rapidoid.u.U;
import org.rapidoid.writable.Writable;

public class ReusableWritable
extends OutputStream
implements Writable {
    private static final int MAX_SIZE = 0x8000000;
    private byte[] bytes;
    private int count;

    public ReusableWritable() {
        this(128);
    }

    public ReusableWritable(int size) {
        U.must(size >= 0);
        this.bytes = new byte[size];
    }

    public int capacity() {
        return this.bytes.length;
    }

    private void requireCapacity(int requiredCapacity) {
        if (requiredCapacity > this.capacity()) {
            this.expand(requiredCapacity);
        }
    }

    private void expand(int requiredCapacity) {
        long newCapacity = this.capacity() * 2;
        if (newCapacity < (long)requiredCapacity) {
            newCapacity = requiredCapacity;
        }
        U.must((newCapacity = Math.min(newCapacity, 0x8000000L)) >= (long)requiredCapacity, "Cannot expand the buffer to size %s, the limit is %s!", requiredCapacity, newCapacity);
        this.bytes = Arrays.copyOf(this.bytes, (int)newCapacity);
    }

    public void reset() {
        this.count = 0;
    }

    public int size() {
        return this.count;
    }

    public byte[] array() {
        return this.bytes;
    }

    public byte[] copy() {
        return Arrays.copyOf(this.bytes, this.count);
    }

    @Override
    public void writeByte(byte byteValue) {
        this.requireCapacity(this.count + 1);
        this.bytes[this.count] = byteValue;
        ++this.count;
    }

    @Override
    public void writeBytes(byte[] src) {
        this.writeBytes(src, 0, src.length);
    }

    @Override
    public void writeBytes(byte[] src, int offset, int length) {
        if (offset < 0 || offset > src.length || length < 0 || offset + length - src.length > 0) {
            throw new IndexOutOfBoundsException();
        }
        this.requireCapacity(this.count + length);
        System.arraycopy(src, offset, this.bytes, this.count, length);
        this.count += length;
    }

    @Override
    public void write(int src) {
        this.writeByte((byte)src);
    }

    @Override
    public void write(byte[] src, int off, int len) {
        this.writeBytes(src, off, len);
    }

    @Override
    public void write(byte[] src) {
        this.writeBytes(src);
    }
}

