/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.nio.ByteBuffer;
import java.util.UUID;
import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Str;
import org.rapidoid.crypto.Crypto;
import org.rapidoid.u.U;

public final class TUUID
extends RapidoidThing
implements Comparable<TUUID> {
    private final long time;
    private final long uuidHigh;
    private final long uuidLow;

    public TUUID() {
        UUID uuid = UUID.randomUUID();
        this.time = U.time();
        this.uuidHigh = uuid.getMostSignificantBits();
        this.uuidLow = uuid.getLeastSignificantBits();
    }

    public TUUID(long time, long uuidHigh, long uuidLow) {
        this.time = time;
        this.uuidHigh = uuidHigh;
        this.uuidLow = uuidLow;
    }

    public TUUID(long time, String id) {
        this.time = time;
        byte[] hash = Crypto.md5Bytes(id.getBytes());
        ByteBuffer buf = ByteBuffer.wrap(hash);
        this.uuidHigh = buf.getLong();
        this.uuidLow = buf.getLong();
    }

    public long time() {
        return this.time;
    }

    public long uuidHigh() {
        return this.uuidHigh;
    }

    public long uuidLow() {
        return this.uuidLow;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        TUUID tuuid = (TUUID)o;
        if (this.time != tuuid.time) {
            return false;
        }
        if (this.uuidHigh != tuuid.uuidHigh) {
            return false;
        }
        return this.uuidLow == tuuid.uuidLow;
    }

    public int hashCode() {
        int result = (int)(this.time ^ this.time >>> 32);
        result = 31 * result + (int)(this.uuidHigh ^ this.uuidHigh >>> 32);
        result = 31 * result + (int)(this.uuidLow ^ this.uuidLow >>> 32);
        return result;
    }

    @Override
    public int compareTo(TUUID other) {
        int cmp = TUUID.cmp(this.time, other.time);
        if (cmp != 0) {
            return cmp;
        }
        cmp = TUUID.cmp(this.uuidHigh, other.uuidHigh);
        if (cmp != 0) {
            return cmp;
        }
        cmp = TUUID.cmp(this.uuidLow, other.uuidLow);
        if (cmp != 0) {
            return cmp;
        }
        return 0;
    }

    private static int cmp(long a, long b) {
        return a < b ? -1 : (a > b ? 1 : 0);
    }

    public byte[] toBytes() {
        ByteBuffer buf = ByteBuffer.wrap(new byte[24]);
        buf.putLong(this.time);
        buf.putLong(this.uuidHigh);
        buf.putLong(this.uuidLow);
        return buf.array();
    }

    public static TUUID fromBytes(byte[] bytes) {
        U.must(bytes.length == 24, "Expected 24 bytes, got: %s", bytes.length);
        ByteBuffer buf = ByteBuffer.wrap(bytes);
        return new TUUID(buf.getLong(), buf.getLong(), buf.getLong());
    }

    public String toString() {
        return Str.toWebSafeBase64(this.toBytes());
    }

    public static TUUID fromString(String tuuid) {
        U.notNull(tuuid, "TUUID", new Object[0]);
        return TUUID.fromBytes(Str.fromWebSafeBase64(tuuid));
    }
}

