/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import org.rapidoid.RapidoidThing;
import org.rapidoid.commons.Rnd;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;
import org.rapidoid.util.SimpleBucket;
import org.rapidoid.util.SimpleList;

public class SimpleHashTable<T>
extends RapidoidThing {
    private static final int DEFAULT_BUCKET_SIZE = 8;
    public final SimpleBucket<T>[] buckets;
    private final int bucketSize;
    public final int factor;
    private final int hashMask;
    private final int xor = Rnd.rnd();

    public SimpleHashTable(int capacity, int bucketSize) {
        this(capacity, bucketSize, true);
    }

    public SimpleHashTable(int capacity, int bucketSize, boolean unbounded) {
        U.must(capacity > 0, "The capacity must be a positive number!");
        if (bucketSize <= 0) {
            bucketSize = 8;
        }
        int factor = SimpleHashTable.calcSizeFactor(capacity, bucketSize);
        int width = SimpleHashTable.calcWidth(factor);
        this.bucketSize = bucketSize;
        this.buckets = new SimpleList[width];
        this.factor = factor;
        this.hashMask = Msc.bitMask(factor);
        U.must(capacity <= this.capacity(), "capacity=%s, realCapacity=%s, bucketSize=%s", capacity, this.capacity(), bucketSize);
        for (int i = 0; i < this.buckets.length; ++i) {
            this.buckets[i] = this.createBucket(bucketSize, unbounded);
        }
    }

    private static int calcSizeFactor(int capacity, int bucketSize) {
        int requiredWidth = (int)Math.ceil((float)capacity * 1.0f / (float)bucketSize);
        return Msc.log2(requiredWidth);
    }

    private static int calcWidth(int factor) {
        return (int)Math.pow(2.0, factor);
    }

    public int bucketSize() {
        return this.bucketSize;
    }

    public int capacity() {
        return this.buckets.length * this.bucketSize;
    }

    protected SimpleBucket<T> createBucket(int bucketSize, boolean unbounded) {
        U.must(unbounded, "Only unbounded buckets are supported!");
        return new SimpleList(bucketSize);
    }

    public void put(long key, T value) {
        this.bucket(key).add(value);
    }

    public SimpleBucket<T> bucket(long key) {
        int index = this.index(key);
        return this.getBucketAt(index);
    }

    public SimpleBucket<T> getBucketAt(int index) {
        SimpleBucket<T> list;
        while ((list = this.buckets[index]) == null) {
        }
        return list;
    }

    public int index(long key) {
        return (int)((key ^ (long)this.xor) & (long)this.hashMask);
    }

    public void clear() {
        for (int i = 0; i < this.buckets.length; ++i) {
            this.clearBucket(i);
        }
    }

    protected void clearBucket(int index) {
        this.getBucketAt(index).clear();
    }

    public int bucketCount() {
        return this.buckets.length;
    }
}

