/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.util;

import java.io.Closeable;
import java.io.IOException;
import java.util.concurrent.Callable;
import org.rapidoid.RapidoidThing;

public final class LazyInit<T>
extends RapidoidThing {
    private final Callable<T> initializer;
    private volatile T initializedValue;

    public LazyInit(Callable<T> initializer) {
        this.initializer = initializer;
    }

    public LazyInit(final Class<T> clazz) {
        this(new Callable<T>(){

            @Override
            public T call() throws Exception {
                return clazz.newInstance();
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T get() {
        T value = this.initializedValue;
        if (value == null) {
            LazyInit lazyInit = this;
            synchronized (lazyInit) {
                value = this.initializedValue;
                if (value == null) {
                    value = this.initializedValue = this.initialize();
                }
            }
        }
        return value;
    }

    private T initialize() {
        try {
            return this.initializer.call();
        }
        catch (Exception e) {
            throw new RuntimeException("Lazy initialization error!", e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public T reset() {
        T value = this.initializedValue;
        if (value != null) {
            LazyInit lazyInit = this;
            synchronized (lazyInit) {
                value = this.initializedValue;
                if (value != null) {
                    this.initializedValue = null;
                }
            }
        }
        return value;
    }

    public T resetAndClose() {
        T value = this.reset();
        if (value != null) {
            if (value instanceof Closeable) {
                LazyInit.close((Closeable)value);
            } else {
                throw new IllegalStateException("Cannot close the lazily initialized value, it's not Closeable!");
            }
        }
        return value;
    }

    private static void close(Closeable closeable) {
        try {
            closeable.close();
        }
        catch (IOException e) {
            throw new RuntimeException("Error occurred while closing the lazily initialized value!", e);
        }
    }

    public void setValue(T value) {
        this.initializedValue = value;
    }

    public T getValue() {
        return this.initializedValue;
    }

    public boolean isInitialized() {
        return this.initializedValue != null;
    }
}

