/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.test;

import org.junit.Assert;
import org.rapidoid.RapidoidThing;
import org.rapidoid.log.Log;

public abstract class RapidoidTest
extends RapidoidThing {
    private volatile boolean hasError;

    protected void clearErrors() {
        this.hasError = false;
    }

    protected void registerError(AssertionError e) {
        this.hasError = true;
        Log.error("Error occurred while executing test!", (Throwable)((Object)e));
    }

    protected boolean hasError() {
        return this.hasError;
    }

    protected void fail(String msg) {
        try {
            Assert.fail((String)msg);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void isNull(Object value) {
        try {
            Assert.assertNull((Object)value);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void notNull(Object value) {
        try {
            Assert.assertNotNull((Object)value);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void isTrue(boolean cond) {
        try {
            Assert.assertTrue((boolean)cond);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void isFalse(boolean cond) {
        try {
            Assert.assertFalse((boolean)cond);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void neq(Object unexpected, Object actual) {
        try {
            Assert.assertNotEquals((Object)unexpected, (Object)actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(Object expected, Object actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(String expected, String actual) {
        try {
            Assert.assertEquals((Object)expected, (Object)actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(char expected, char actual) {
        try {
            Assert.assertEquals((long)expected, (long)actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(long expected, long actual) {
        try {
            Assert.assertEquals((long)expected, (long)actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(double expected, double actual) {
        this.eq(actual, expected, 0.0);
    }

    protected void eq(double expected, double actual, double delta) {
        try {
            Assert.assertEquals((double)expected, (double)actual, (double)delta);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(byte[] expected, byte[] actual) {
        try {
            Assert.assertArrayEquals((byte[])expected, (byte[])actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(char[] expected, char[] actual) {
        try {
            Assert.assertArrayEquals((char[])expected, (char[])actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(int[] expected, int[] actual) {
        try {
            Assert.assertArrayEquals((int[])expected, (int[])actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(long[] expected, long[] actual) {
        try {
            Assert.assertArrayEquals((long[])expected, (long[])actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(float[] expected, float[] actual, float delta) {
        try {
            Assert.assertArrayEquals((float[])expected, (float[])actual, (float)delta);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(double[] expected, double[] actual, double delta) {
        try {
            Assert.assertArrayEquals((double[])expected, (double[])actual, (double)delta);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(boolean[] expected, boolean[] actual) {
        try {
            Assert.assertArrayEquals((boolean[])expected, (boolean[])actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void eq(Object[] expected, Object[] actual) {
        try {
            Assert.assertArrayEquals((Object[])expected, (Object[])actual);
        }
        catch (AssertionError e) {
            this.registerError(e);
            throw e;
        }
    }

    protected void contains(String expectedSubstring, String actual) {
        this.notNull(actual);
        this.isTrue(actual.contains(expectedSubstring));
    }
}

