/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.test;

import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.rapidoid.RapidoidModule;
import org.rapidoid.RapidoidModules;
import org.rapidoid.annotation.IntegrationTest;
import org.rapidoid.beany.Metadata;
import org.rapidoid.log.Log;
import org.rapidoid.test.RapidoidTest;
import org.rapidoid.util.Msc;

public abstract class RapidoidIntegrationTest
extends RapidoidTest {
    @Before
    public final void beforeRapidoidTest() {
        Log.info("--------------------------------------------------------------------------------");
        Log.info("@" + Msc.processId() + " TEST " + this.getClass().getCanonicalName());
        Log.info("--------------------------------------------------------------------------------");
        this.clearErrors();
        this.isTrue(Msc.isInsideTest());
        RapidoidIntegrationTest.before(this);
        RapidoidIntegrationTest.start(this);
    }

    @After
    public final void afterRapidoidTest() {
        RapidoidIntegrationTest.after(this);
        if (this.hasError()) {
            Assert.fail((String)"Assertion error(s) occurred, probably were caught or were thrown on non-main thread!");
        }
    }

    public static void before(Object test) {
        Msc.logSection("INITIALIZE");
        for (RapidoidModule mod : RapidoidModules.getAllAvailable()) {
            Log.debug("Initializing module before the test", "module", mod.name(), "order", mod.order());
            mod.beforeTest(test);
        }
        Log.debug("All modules are initialized");
    }

    public static void start(Object test) {
        RapidoidIntegrationTest.runMainClass(test);
        for (RapidoidModule mod : RapidoidModules.getAllAvailable()) {
            Log.debug("Initializing the test", "module", mod.name(), "order", mod.order());
            mod.initTest(test);
        }
        Msc.logSection("START TEST");
    }

    private static void runMainClass(Object test) {
        IntegrationTest testInfo = Metadata.getAnnotationRecursive(test.getClass(), IntegrationTest.class);
        if (testInfo != null) {
            Msc.logSection("RUN MAIN");
            Class<?> main = testInfo.main();
            String[] args = testInfo.args();
            Msc.invokeMain(main, args);
        }
    }

    public static void after(Object test) {
        Msc.logSection("END TEST");
        for (RapidoidModule mod : RapidoidModules.getAllAvailable()) {
            mod.afterTest(test);
        }
        Msc.logSection("FINISHED");
    }
}

