/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.serialize;

import java.nio.ByteBuffer;
import org.rapidoid.RapidoidThing;
import org.rapidoid.serialize.TypeSpecificDeserializer;
import org.rapidoid.serialize.TypeSpecificSerializer;
import org.rapidoid.u.U;

public class Serialize
extends RapidoidThing {
    private static final TypeSpecificSerializer SERIALIZER = new TypeSpecificSerializer();
    private static final TypeSpecificDeserializer DESERIALIZER = new TypeSpecificDeserializer();

    public static int serialize(byte[] dest, Object value) {
        ByteBuffer buf = ByteBuffer.wrap(dest);
        return Serialize.serialize(buf, value);
    }

    public static int serialize(ByteBuffer buf, Object value) {
        int pos = buf.position();
        SERIALIZER.serialize(buf, value);
        buf.put((byte)33);
        return buf.position() - pos;
    }

    public static Object deserialize(ByteBuffer buf) {
        Object value = DESERIALIZER.deserialize(buf);
        U.must(buf.get() == 33);
        return value;
    }

    public static Object deserialize(byte[] bytes) {
        return Serialize.deserialize(ByteBuffer.wrap(bytes));
    }
}

