/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.security;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.beany.Beany;
import org.rapidoid.beany.Metadata;
import org.rapidoid.beany.Prop;
import org.rapidoid.cls.Cls;
import org.rapidoid.security.DataPermissions;
import org.rapidoid.security.annotation.Administrator;
import org.rapidoid.security.annotation.CanChange;
import org.rapidoid.security.annotation.CanDelete;
import org.rapidoid.security.annotation.CanInsert;
import org.rapidoid.security.annotation.CanManage;
import org.rapidoid.security.annotation.CanRead;
import org.rapidoid.security.annotation.LoggedIn;
import org.rapidoid.security.annotation.Manager;
import org.rapidoid.security.annotation.Moderator;
import org.rapidoid.security.annotation.Roles;
import org.rapidoid.u.U;

public class Secure
extends RapidoidThing {
    public static boolean hasRoleForClass(String username, Set<String> roles, String role, Class<?> clazz) {
        return Secure.hasRole(username, roles, role, Cls.unproxy(clazz), null);
    }

    public static boolean hasRoleForRecord(String username, Set<String> roles, String role, Object record) {
        return Secure.hasRole(username, roles, role, Cls.unproxy(record.getClass()), record);
    }

    public static boolean isOwnerOf(String username, Set<String> roles, Object record) {
        return Secure.isOwnerOf(username, record);
    }

    public static boolean isSharedWith(String username, Set<String> roles, Object record) {
        return Secure.isSharedWith(username, record);
    }

    public static boolean canAccessClass(String username, Set<String> roles, Class<?> clazz) {
        U.notNull(clazz, "class", new Object[0]);
        clazz = Cls.unproxy(clazz);
        return Secure.hasRoleBasedClassAccess(username, roles, clazz) && Secure.canAccessClass(username, clazz);
    }

    public static boolean canAccessMethod(String username, Set<String> roles, Method method) {
        U.notNull(method, "method", new Object[0]);
        Class<?> clazz = method.getDeclaringClass();
        return Secure.canAccessClass(username, roles, clazz) && Secure.hasRoleBasedMethodAccess(username, roles, method);
    }

    public static boolean hasRoleBasedClassAccess(String username, Set<String> roles, Class<?> clazz) {
        U.notNull(clazz, "class", new Object[0]);
        clazz = Cls.unproxy(clazz);
        return Secure.hasRoleBasedAccess(username, roles, clazz, null);
    }

    public static boolean hasRoleBasedObjectAccess(String username, Set<String> roles, Object target) {
        U.notNull(target, "target", new Object[0]);
        return Secure.hasRoleBasedAccess(username, roles, Cls.unproxy(target.getClass()), target);
    }

    private static boolean hasRoleBasedAccess(String username, Set<String> roles, Class<?> clazz, Object target) {
        Set<String> rolesAllowed = Secure.getRolesAllowed(clazz = Cls.unproxy(clazz));
        return U.isEmpty(rolesAllowed) || Secure.hasAnyRole(username, roles, rolesAllowed, clazz, target);
    }

    public static boolean hasRoleBasedMethodAccess(String username, Set<String> roles, Method method) {
        U.notNull(method, "method", new Object[0]);
        Set<String> rolesAllowed = Secure.getRolesAllowed(method);
        return U.isEmpty(rolesAllowed) || Secure.hasAnyRole(username, roles, rolesAllowed);
    }

    public static boolean hasAnyRole(String username, Set<String> roles, Set<String> targetRoles, Class<?> clazz, Object target) {
        clazz = Cls.unproxy(clazz);
        for (String role : targetRoles) {
            if (!Secure.hasRole(username, roles, role, clazz, target)) continue;
            return true;
        }
        return false;
    }

    public static boolean hasAnyRole(String username, Set<String> roles, Set<String> targetRoles) {
        for (String role : targetRoles) {
            if (!Secure.hasRole(username, roles, role)) continue;
            return true;
        }
        return false;
    }

    public static DataPermissions getPropertyPermissions(String username, Set<String> roles, Class<?> clazz, Object target, String propertyName) {
        U.notNull(clazz, "class", new Object[0]);
        clazz = Cls.unproxy(clazz);
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz)) {
            return DataPermissions.ALL;
        }
        if (!Secure.hasRoleBasedAccess(username, roles, clazz, target)) {
            return DataPermissions.NONE;
        }
        CanRead canRead = Metadata.propAnnotation(clazz, propertyName, CanRead.class);
        CanInsert canInsert = Metadata.propAnnotation(clazz, propertyName, CanInsert.class);
        CanChange canChange = Metadata.propAnnotation(clazz, propertyName, CanChange.class);
        CanDelete canDelete = Metadata.propAnnotation(clazz, propertyName, CanDelete.class);
        CanManage canManage = Metadata.propAnnotation(clazz, propertyName, CanManage.class);
        if (canRead == null && canInsert == null && canChange == null && canDelete == null && canManage == null) {
            return DataPermissions.ALL;
        }
        boolean read = canRead == null || Secure.hasAnyRole(username, roles, Secure.roles(canRead.value()), clazz, target);
        boolean insert = canInsert != null && Secure.hasAnyRole(username, roles, Secure.roles(canInsert.value()), clazz, target);
        boolean change = canChange != null && Secure.hasAnyRole(username, roles, Secure.roles(canChange.value()), clazz, target);
        boolean delete = canDelete != null && Secure.hasAnyRole(username, roles, Secure.roles(canDelete.value()), clazz, target);
        boolean manage = canManage != null && Secure.hasAnyRole(username, roles, Secure.roles(canManage.value()), clazz, target);
        return DataPermissions.from(read, insert |= manage, change |= manage, delete |= manage);
    }

    private static Set<String> roles(String[] roles) {
        return U.set(roles);
    }

    public static DataPermissions getClassPermissions(String username, Set<String> roles, Class<?> clazz) {
        U.notNull(clazz, "class", new Object[0]);
        clazz = Cls.unproxy(clazz);
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz)) {
            return DataPermissions.ALL;
        }
        if (!Secure.hasRoleBasedAccess(username, roles, clazz, null)) {
            return DataPermissions.NONE;
        }
        CanRead canRead = Metadata.classAnnotation(clazz, CanRead.class);
        CanInsert canInsert = Metadata.classAnnotation(clazz, CanInsert.class);
        CanChange canChange = Metadata.classAnnotation(clazz, CanChange.class);
        CanDelete canDelete = Metadata.classAnnotation(clazz, CanDelete.class);
        CanManage canManage = Metadata.classAnnotation(clazz, CanManage.class);
        if (canRead == null && canInsert == null && canChange == null && canDelete == null && canManage == null) {
            return DataPermissions.ALL;
        }
        boolean read = canRead == null || Secure.hasAnyRole(username, roles, Secure.roles(canRead.value()), clazz, null);
        boolean insert = canInsert != null && Secure.hasAnyRole(username, roles, Secure.roles(canInsert.value()), clazz, null);
        boolean change = canChange != null && Secure.hasAnyRole(username, roles, Secure.roles(canChange.value()), clazz, null);
        boolean delete = canDelete != null && Secure.hasAnyRole(username, roles, Secure.roles(canDelete.value()), clazz, null);
        boolean manage = canManage != null && Secure.hasAnyRole(username, roles, Secure.roles(canManage.value()), clazz, null);
        return DataPermissions.from(read, insert |= manage, change |= manage, delete |= manage);
    }

    public static DataPermissions getObjectPermissions(String username, Set<String> roles, Object target) {
        U.notNull(target, "target", new Object[0]);
        Class<?> clazz = target.getClass();
        clazz = Cls.unproxy(clazz);
        if (Collection.class.isAssignableFrom(clazz) || Map.class.isAssignableFrom(clazz) || Object[].class.isAssignableFrom(clazz)) {
            return DataPermissions.ALL;
        }
        if (!Secure.hasRoleBasedAccess(username, roles, clazz, null)) {
            return DataPermissions.NONE;
        }
        CanRead canRead = Metadata.classAnnotation(clazz, CanRead.class);
        CanInsert canInsert = Metadata.classAnnotation(clazz, CanInsert.class);
        CanChange canChange = Metadata.classAnnotation(clazz, CanChange.class);
        CanDelete canDelete = Metadata.classAnnotation(clazz, CanDelete.class);
        CanManage canManage = Metadata.classAnnotation(clazz, CanManage.class);
        if (canRead == null && canInsert == null && canChange == null && canDelete == null && canManage == null) {
            return DataPermissions.ALL;
        }
        boolean read = canRead == null || Secure.hasAnyRole(username, roles, Secure.roles(canRead.value()), clazz, target);
        boolean insert = canInsert != null && Secure.hasAnyRole(username, roles, Secure.roles(canInsert.value()), clazz, target);
        boolean change = canChange != null && Secure.hasAnyRole(username, roles, Secure.roles(canChange.value()), clazz, target);
        boolean delete = canDelete != null && Secure.hasAnyRole(username, roles, Secure.roles(canDelete.value()), clazz, target);
        boolean manage = canManage != null && Secure.hasAnyRole(username, roles, Secure.roles(canManage.value()), clazz, target);
        return DataPermissions.from(read, insert |= manage, change |= manage, delete |= manage);
    }

    public static boolean canRead(String username, Set<String> roles, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, roles, record) && Secure.getObjectPermissions((String)username, roles, (Object)record).read;
    }

    public static boolean canInsert(String username, Set<String> roles, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, roles, record) && Secure.getObjectPermissions((String)username, roles, (Object)record).insert;
    }

    public static boolean canUpdate(String username, Set<String> roles, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, roles, record) && Secure.getObjectPermissions((String)username, roles, (Object)record).change;
    }

    public static boolean canDelete(String username, Set<String> roles, Object record) {
        return Secure.hasRoleBasedObjectAccess(username, roles, record) && Secure.getObjectPermissions((String)username, roles, (Object)record).delete;
    }

    public static boolean canReadProperty(String username, Set<String> roles, Object record, String property) {
        return Secure.hasRoleBasedObjectAccess(username, roles, record) && Secure.getObjectPermissions((String)username, roles, (Object)record).read && Secure.getPropertyPermissions((String)username, roles, record.getClass(), (Object)record, (String)property).read;
    }

    public static boolean canUpdateProperty(String username, Set<String> roles, Object record, String property) {
        return Secure.hasRoleBasedObjectAccess(username, roles, record) && Secure.getObjectPermissions((String)username, roles, (Object)record).change && Secure.getPropertyPermissions((String)username, roles, record.getClass(), (Object)record, (String)property).change;
    }

    public static void resetInvisibleProperties(String username, Set<String> roles, Object record) {
        for (Prop prop : Beany.propertiesOf(record)) {
            if (Secure.getPropertyPermissions((String)username, roles, record.getClass(), (Object)record, (String)prop.getName()).read) continue;
            prop.reset(record);
        }
    }

    public static Set<String> getRolesAllowed(Map<Class<?>, Annotation> annotations) {
        Set<String> roles = U.set();
        for (Map.Entry<Class<?>, Annotation> e : annotations.entrySet()) {
            Annotation ann = e.getValue();
            Class<? extends Annotation> type = ann.annotationType();
            if (type.equals(Administrator.class)) {
                roles.add("administrator");
                continue;
            }
            if (type.equals(Manager.class)) {
                roles.add("manager");
                continue;
            }
            if (type.equals(Moderator.class)) {
                roles.add("moderator");
                continue;
            }
            if (type.equals(LoggedIn.class)) {
                roles.add("logged_in");
                continue;
            }
            if (!type.equals(Roles.class)) continue;
            String[] values = ((Roles)ann).value();
            U.must(values.length > 0, "At least one role must be specified in @Roles annotation!");
            for (String r : values) {
                roles.add(r.toLowerCase());
            }
        }
        return roles;
    }

    public static Set<String> getRolesAllowed(Class<?> clazz) {
        Map<Class<?>, Annotation> annotations = Metadata.classAnnotations(clazz);
        return Secure.getRolesAllowed(annotations);
    }

    public static Set<String> getRolesAllowed(Method method) {
        Map<Class<?>, Annotation> annotations = Metadata.methodAnnotations(method);
        return Secure.getRolesAllowed(annotations);
    }

    public static boolean canAccessClass(String username, Class<?> clazz) {
        return true;
    }

    public static boolean hasRole(String username, Set<String> roles, String role, Class<?> clazz, Object record) {
        if ("anybody".equalsIgnoreCase(role)) {
            return true;
        }
        if (U.isEmpty(username) || U.isEmpty(role)) {
            return false;
        }
        if (record != null) {
            if (role.equalsIgnoreCase("owner")) {
                return Secure.isOwnerOf(username, record);
            }
            if (role.equalsIgnoreCase("shared_with")) {
                return Secure.isSharedWith(username, record);
            }
        }
        return Secure.hasRole(username, roles, role);
    }

    protected static boolean hasSpecialRoleInDevMode(String username, String role) {
        return false;
    }

    protected static boolean hasRole(String username, Set<String> roles, String role) {
        if (Secure.hasSpecialRoleInDevMode(username, role)) {
            return true;
        }
        if (role.equalsIgnoreCase("logged_in")) {
            return !U.isEmpty(username);
        }
        for (String r : roles) {
            if (!r.equalsIgnoreCase(role)) continue;
            return true;
        }
        return false;
    }

    public static boolean isAdministrator(String username, Set<String> roles) {
        return Secure.hasRole(username, roles, "administrator", null, null);
    }

    public static boolean isManager(String username, Set<String> roles) {
        return Secure.hasRole(username, roles, "manager", null, null);
    }

    public static boolean isModerator(String username, Set<String> roles) {
        return Secure.hasRole(username, roles, "moderator", null, null);
    }

    public static DataPermissions classPermissions(String username, Class<?> clazz) {
        return DataPermissions.ALL;
    }

    public static DataPermissions recordPermissions(String username, Object record) {
        return DataPermissions.ALL;
    }

    public static DataPermissions propertyPermissions(String username, Object record, String propertyName) {
        return DataPermissions.ALL;
    }

    public static boolean isOwnerOf(String username, Object record) {
        if (U.isEmpty(username) || record == null) {
            return false;
        }
        Object owner = Beany.getPropValue(record, "createdBy", null);
        return owner instanceof String && username.equalsIgnoreCase(owner);
    }

    public static boolean isSharedWith(String username, Object record) {
        if (U.isEmpty(username) || record == null) {
            return false;
        }
        Object sharedWith = Beany.getPropValue(record, "sharedWith", null);
        if (sharedWith != null && sharedWith instanceof Collection) {
            for (Object user : (Collection)sharedWith) {
                if (!username.equalsIgnoreCase(Beany.getPropValue(user, "username", ""))) continue;
                return true;
            }
        }
        return false;
    }
}

