/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.scan;

import java.io.InputStream;
import java.lang.annotation.Annotation;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.lambda.Operation;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;

public class ScanParams
extends RapidoidThing {
    private volatile String[] packages;
    private volatile String matching;
    private volatile Class<? extends Annotation>[] annotated;
    private volatile ClassLoader classLoader;
    private volatile String[] classpath;
    private volatile Predicate<InputStream> bytecodeFilter;

    public ScanParams in(String ... packages) {
        this.packages = packages;
        return this;
    }

    public ScanParams in(Iterable<String> packages) {
        return this.in(U.arrayOf(String.class, packages));
    }

    public String[] in() {
        return this.packages;
    }

    public ScanParams matching(String matching) {
        this.matching = matching;
        return this;
    }

    public String matching() {
        return this.matching;
    }

    public ScanParams annotated(Class<? extends Annotation> ... annotated) {
        this.annotated = annotated;
        return this;
    }

    public ScanParams annotated(Collection<Class<? extends Annotation>> annotated) {
        return this.annotated(U.arrayOf(Class.class, annotated));
    }

    public Class<? extends Annotation>[] annotated() {
        return this.annotated;
    }

    public ScanParams classLoader(ClassLoader classLoader) {
        this.classLoader = classLoader;
        return this;
    }

    public ClassLoader classLoader() {
        return this.classLoader;
    }

    public String[] classpath() {
        return this.classpath;
    }

    public ScanParams classpath(String ... classpath) {
        this.classpath = classpath;
        return this;
    }

    public Predicate<InputStream> bytecodeFilter() {
        return this.bytecodeFilter;
    }

    public ScanParams bytecodeFilter(Predicate<InputStream> bytecodeFilter) {
        this.bytecodeFilter = bytecodeFilter;
        return this;
    }

    public List<String> getAll() {
        return ClasspathUtil.getClasses(this);
    }

    public List<Class<?>> loadAll() {
        return ClasspathUtil.loadClasses(this);
    }

    public void forEach(Operation<Class<?>> classOperation) {
        for (Class<?> cls : this.loadAll()) {
            try {
                classOperation.execute(cls);
            }
            catch (Exception e) {
                Log.error("Cannot process annotated class!", e);
            }
        }
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ScanParams that = (ScanParams)o;
        if (!Arrays.equals(this.packages, that.packages)) {
            return false;
        }
        if (this.matching != null ? !this.matching.equals(that.matching) : that.matching != null) {
            return false;
        }
        if (!Arrays.equals(this.annotated, that.annotated)) {
            return false;
        }
        if (this.classLoader != null ? !this.classLoader.equals(that.classLoader) : that.classLoader != null) {
            return false;
        }
        if (!Arrays.equals(this.classpath, that.classpath)) {
            return false;
        }
        return this.bytecodeFilter != null ? this.bytecodeFilter.equals(that.bytecodeFilter) : that.bytecodeFilter == null;
    }

    public int hashCode() {
        int result = Arrays.hashCode(this.packages);
        result = 31 * result + (this.matching != null ? this.matching.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.annotated);
        result = 31 * result + (this.classLoader != null ? this.classLoader.hashCode() : 0);
        result = 31 * result + Arrays.hashCode(this.classpath);
        result = 31 * result + (this.bytecodeFilter != null ? this.bytecodeFilter.hashCode() : 0);
        return result;
    }
}

