/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.scan;

import java.io.File;
import java.io.IOException;
import java.net.URL;
import java.net.URLClassLoader;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Enumeration;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.rapidoid.cls.Cls;
import org.rapidoid.commons.Str;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.lambda.Predicate;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathScanner;
import org.rapidoid.scan.ScanParams;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class ClasspathUtil
extends RapidoidInitializer {
    private static final Set<String> CLASSPATH = new TreeSet<String>();
    private static volatile String appJar;
    private static volatile String rootPackage;
    private static volatile ClassLoader defaultClassLoader;

    private ClasspathUtil() {
    }

    public static synchronized void reset() {
        CLASSPATH.clear();
        appJar = null;
    }

    public static synchronized List<File> files(String packageName, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        ClasspathUtil.files(packageName, files, filter);
        return files;
    }

    public static synchronized List<File> dir(String dir, Predicate<File> filter) {
        ArrayList<File> files = new ArrayList<File>();
        ClasspathUtil.getFiles(files, new File(dir), filter);
        return files;
    }

    public static synchronized void files(String packageName, Collection<File> files, Predicate<File> filter) {
        Enumeration<URL> urls = ClasspathUtil.getResources(packageName);
        while (urls.hasMoreElements()) {
            URL url = urls.nextElement();
            File file = new File(url.getFile());
            ClasspathUtil.getFiles(files, file, filter);
        }
    }

    public static Enumeration<URL> getResources(String name) {
        name = name.replace('.', '/');
        try {
            return Cls.classLoader().getResources(name);
        }
        catch (IOException e) {
            throw U.rte("Cannot scan: " + name, e);
        }
    }

    private static void getFiles(Collection<File> files, File file, Predicate<File> filter) {
        if (file.isDirectory()) {
            Log.trace("scanning directory", "dir", file);
            for (File f : file.listFiles()) {
                if (f.isDirectory()) {
                    ClasspathUtil.getFiles(files, f, filter);
                    continue;
                }
                Log.trace("scanned file", "file", f);
                try {
                    if (filter != null && !filter.eval(f)) continue;
                    files.add(f);
                }
                catch (Exception e) {
                    throw U.rte(e);
                }
            }
        }
    }

    public static synchronized Set<String> getClasspath() {
        if (CLASSPATH.isEmpty()) {
            ClassLoader cl;
            String classpathProp = System.getProperty("java.class.path");
            if (classpathProp != null) {
                String[] classpathEntries;
                for (String cpe : classpathEntries = classpathProp.split(File.pathSeparator)) {
                    cpe = Str.trimr(cpe, '/');
                    CLASSPATH.add(new File(cpe).getAbsolutePath());
                }
            }
            if ((cl = ClassLoader.getSystemClassLoader()) instanceof URLClassLoader) {
                URL[] urls;
                for (URL url : urls = ((URLClassLoader)cl).getURLs()) {
                    String path = Msc.urlDecode(Str.trimr(url.getPath(), '/'));
                    CLASSPATH.add(new File(path).getAbsolutePath());
                }
            }
            if (U.isEmpty(appJar)) {
                ClasspathUtil.inferAppJarFromClasspath();
            }
        }
        return CLASSPATH;
    }

    private static void inferAppJarFromClasspath() {
        for (String cp : CLASSPATH) {
            if (!cp.endsWith("/app.jar") && !cp.endsWith("\\app.jar")) continue;
            appJar = cp;
            return;
        }
    }

    public static synchronized Set<String> getClasspathFolders() {
        Set<String> folders = U.set();
        Set<String> cps = ClasspathUtil.getClasspath();
        for (String cp : cps) {
            if (!new File(cp).isDirectory()) continue;
            folders.add(cp);
        }
        return folders;
    }

    public static synchronized Set<String> getClasspathJars() {
        Set<String> jars = U.set();
        Set<String> cps = ClasspathUtil.getClasspath();
        for (String cp : cps) {
            if (!new File(cp).isFile() || !cp.substring(cp.length() - 4).equalsIgnoreCase(".JAR")) continue;
            jars.add(cp);
        }
        return jars;
    }

    public static String getRootPackage() {
        return rootPackage;
    }

    public static void setRootPackage(String rootPackage) {
        ClasspathUtil.rootPackage = rootPackage;
    }

    public static ClassLoader getDefaultClassLoader() {
        return defaultClassLoader;
    }

    public static void setDefaultClassLoader(ClassLoader defaultClassLoader) {
        ClasspathUtil.defaultClassLoader = defaultClassLoader;
    }

    public static List<String> getClasses(ScanParams scanParams) {
        return ClasspathScanner.scan(scanParams);
    }

    public static List<Class<?>> loadClasses(ScanParams scanParams) {
        List<String> classNames = ClasspathScanner.scan(scanParams);
        List<Class<?>> classes = U.list();
        ClassLoader classLoader = U.or(scanParams.classLoader(), defaultClassLoader);
        for (String clsName : classNames) {
            try {
                Log.trace("Loading class", "name", clsName);
                classes.add(classLoader != null ? Class.forName(clsName, true, classLoader) : Class.forName(clsName));
            }
            catch (Throwable e) {
                Log.debug("Error while loading class", "name", clsName, "error", e);
            }
        }
        return classes;
    }

    public static Class<?> loadFromJar(String clsName, String jar, ClassLoader classLoader) throws Exception {
        URL url = new File(jar).toURI().toURL();
        URLClassLoader child = new URLClassLoader(U.array(url), classLoader);
        return Class.forName(clsName, true, child);
    }

    public static boolean hasAppJar() {
        ClasspathUtil.getClasspath();
        return appJar != null;
    }

    public static String appJar() {
        return appJar;
    }

    public static void appJar(String appJar) {
        if (U.neq(ClasspathUtil.appJar, appJar)) {
            ClasspathUtil.appJar = appJar;
            boolean exists = new File(appJar).exists();
            if (exists) {
                Log.info("Found application JAR", "!file", appJar);
            }
        }
    }

    public static Set<String> getClasspathStaticFolders() {
        Set<String> folders = U.set();
        for (String cp : ClasspathUtil.getClasspathFolders()) {
            File static2;
            File target;
            File classes = new File(cp);
            if (!classes.getName().equals("classes") || !(target = classes.getParentFile()).getName().equals("target")) continue;
            String project = target.getParent();
            File static1 = new File(Msc.path(project, "src", "main", "resources", "static"));
            if (static1.exists() && static1.isDirectory()) {
                folders.add(static1.getAbsolutePath());
            }
            if (!(static2 = new File(Msc.path(project, "static"))).exists() || !static2.isDirectory()) continue;
            folders.add(static2.getAbsolutePath());
        }
        return folders;
    }

    static {
        rootPackage = null;
        defaultClassLoader = ClasspathUtil.class.getClassLoader();
    }
}

