/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.tls;

import java.nio.ByteBuffer;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLEngineResult;
import javax.net.ssl.SSLException;
import javax.net.ssl.SSLSession;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufUtil;
import org.rapidoid.commons.Err;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.RapidoidConnection;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class RapidoidTLS
extends RapidoidThing {
    private static boolean debugging = false;
    private final SSLContext sslContext;
    private final RapidoidConnection conn;
    private volatile SSLEngine engine;
    private final ByteBuffer appIn;
    public final ByteBuffer netIn;
    final ByteBuffer netOut;

    public RapidoidTLS(SSLContext sslContext, RapidoidConnection conn) {
        this.sslContext = sslContext;
        this.conn = conn;
        this.engine = this.createServerEngine();
        SSLSession session = this.engine.getSession();
        int appBufferMax = session.getApplicationBufferSize();
        int netBufferMax = session.getPacketBufferSize();
        this.appIn = ByteBuffer.allocateDirect(appBufferMax + 64);
        this.netIn = ByteBuffer.allocateDirect(netBufferMax);
        this.netOut = ByteBuffer.allocateDirect(netBufferMax);
    }

    private SSLEngine createServerEngine() {
        SSLEngine engine = this.sslContext.createSSLEngine();
        engine.setUseClientMode(false);
        return engine;
    }

    private void reactToHandshakeStatus(SSLEngineResult.HandshakeStatus status) {
        this.debug("HANDSHAKE STATUS = " + (Object)((Object)status));
        switch (status) {
            case FINISHED: {
                break;
            }
            case NEED_TASK: {
                status = this.executeTasks();
                this.reactToHandshakeStatus(status);
                break;
            }
            case NEED_UNWRAP: {
                this.unwrapInput();
                break;
            }
            case NEED_WRAP: {
                this.wrapOutput();
                break;
            }
            case NOT_HANDSHAKING: {
                break;
            }
            default: {
                throw Err.notExpected();
            }
        }
    }

    private SSLEngineResult.HandshakeStatus executeTasks() {
        Runnable runnable;
        while ((runnable = this.engine.getDelegatedTask()) != null) {
            runnable.run();
        }
        SSLEngineResult.HandshakeStatus hsStatus = this.engine.getHandshakeStatus();
        U.must(hsStatus != SSLEngineResult.HandshakeStatus.NEED_TASK, "handshake shouldn't need additional tasks!");
        this.debug("after tasks: " + (Object)((Object)hsStatus));
        return hsStatus;
    }

    public boolean isClosed() {
        return this.engine.isOutboundDone() && this.engine.isInboundDone();
    }

    public SSLSession getSession() {
        return this.engine.getSession();
    }

    private void debug(String msg, SSLEngineResult result) {
        if (debugging) {
            SSLEngineResult.HandshakeStatus handshakeStatus = result.getHandshakeStatus();
            this.debug(U.frmt("%s (status = %s:%s, consumed=%s, produced=%s)", new Object[]{msg, result.getStatus(), handshakeStatus, result.bytesConsumed(), result.bytesProduced()}));
            if (handshakeStatus.equals((Object)SSLEngineResult.HandshakeStatus.FINISHED)) {
                this.debug("\n<<< HANDSHAKE FINISHED >>>\n");
            }
        }
    }

    private void debug(String msg) {
        if (debugging) {
            U.print(this.conn + " :: " + msg);
        }
    }

    public synchronized boolean unwrapInput() {
        boolean success = false;
        boolean shouldUnwrap = true;
        while (!this.isClosed() && shouldUnwrap && this.netIn.position() > 0) {
            this.debug("- UNWRAP");
            this.netIn.flip();
            this.netIn.mark();
            SSLEngineResult result = this.unwrap(this.netIn, this.appIn);
            boolean underflow = result.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW);
            if (!underflow) {
                this.netIn.compact();
            } else {
                this.netIn.reset();
                this.netIn.compact();
            }
            this.appIn.flip();
            this.conn.input.append(this.appIn);
            this.appIn.clear();
            this.reactToResult(result);
            shouldUnwrap = !result.getStatus().equals((Object)SSLEngineResult.Status.BUFFER_UNDERFLOW) && !result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.NEED_TASK) && !result.getHandshakeStatus().equals((Object)SSLEngineResult.HandshakeStatus.NEED_WRAP);
            success = true;
        }
        return success;
    }

    public synchronized boolean wrapToOutgoing() {
        boolean success = false;
        if (this.conn.output.hasRemaining()) {
            this.debug("- WRAP TO OUTGOING " + this.conn);
            BufUtil.startWriting(this.conn.output);
            BufUtil.startWriting(this.conn.outgoing);
            int bytesConsumed = this.conn.output.sslWrap(this.engine, this.conn.outgoing);
            success = bytesConsumed > 0;
            BufUtil.doneWriting(this.conn.outgoing);
            BufUtil.doneWriting(this.conn.output);
        }
        return success;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void wrapOutput() {
        if (!this.isClosed()) {
            SSLEngineResult result;
            this.debug("- WRAP");
            try {
                result = this.engine.wrap(new ByteBuffer[0], 0, 0, this.netOut);
            }
            catch (SSLException e) {
                throw U.rte(e);
            }
            this.debug("wrap: ", result);
            this.debug("OUT " + this.netOut);
            this.netOut.flip();
            Buf buf = this.conn.outgoing;
            synchronized (buf) {
                this.conn.outgoing.append(this.netOut);
            }
            this.netOut.compact();
            this.reactToResult(result);
        }
    }

    private void reactToResult(SSLEngineResult result) {
        switch (result.getStatus()) {
            case BUFFER_OVERFLOW: {
                this.debug("@@@ BUFFER_OVERFLOW " + this.conn);
                break;
            }
            case BUFFER_UNDERFLOW: {
                this.debug("@@@ BUFFER_UNDERFLOW " + this.conn);
                break;
            }
            case CLOSED: {
                this.debug("@@@ CLOSED " + this.conn);
                this.conn.closeAfterWrite();
                break;
            }
            case OK: {
                this.debug("@@@ OK " + this.conn);
                this.reactToHandshakeStatus(result.getHandshakeStatus());
                break;
            }
            default: {
                throw Err.notExpected();
            }
        }
    }

    public synchronized SSLEngineResult wrap(ByteBuffer src, ByteBuffer dst) {
        try {
            SSLEngineResult result = this.engine.wrap(src, dst);
            this.debug("wrap: ", result);
            return result;
        }
        catch (SSLException e) {
            throw U.rte(e);
        }
    }

    public synchronized SSLEngineResult unwrap(ByteBuffer src, ByteBuffer dst) {
        try {
            SSLEngineResult result = this.engine.unwrap(src, dst);
            this.debug("unwrap: ", result);
            return result;
        }
        catch (SSLException e) {
            throw U.rte(e);
        }
    }

    public SSLEngine engine() {
        return this.engine;
    }

    public synchronized void closeInbound() {
        try {
            this.engine.closeInbound();
        }
        catch (SSLException e) {
            Log.warn("SSL error while closing connection", "message", Msc.errorMsg(e));
        }
    }

    public void reset() {
        this.appIn.clear();
        this.netIn.clear();
        this.netOut.clear();
        this.engine = this.createServerEngine();
    }
}

