/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.net.ServerSocket;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.nio.channels.ServerSocketChannel;
import java.nio.channels.SocketChannel;
import java.util.Iterator;
import java.util.Set;
import javax.net.ssl.SSLContext;
import org.rapidoid.activity.RapidoidThread;
import org.rapidoid.commons.Rnd;
import org.rapidoid.log.Log;
import org.rapidoid.net.NetworkingParams;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.Server;
import org.rapidoid.net.TCPServerInfo;
import org.rapidoid.net.impl.AbstractLoop;
import org.rapidoid.net.impl.LoopStatus;
import org.rapidoid.net.impl.RapidoidConnection;
import org.rapidoid.net.impl.RapidoidWorker;
import org.rapidoid.net.impl.RapidoidWorkerThread;
import org.rapidoid.u.U;

public class RapidoidServerLoop
extends AbstractLoop<Server>
implements Server,
TCPServerInfo {
    private static final int MAX_PENDING_CONNECTIONS = 16384;
    private final NetworkingParams net;
    private final SSLContext sslContext;
    private final Selector selector;
    private ServerSocketChannel serverSocketChannel;
    private volatile RapidoidWorker[] ioWorkers;
    private RapidoidWorker currentWorker;

    public RapidoidServerLoop(NetworkingParams net, SSLContext sslContext) {
        super("server");
        this.net = net;
        this.sslContext = sslContext;
        try {
            this.selector = Selector.open();
        }
        catch (IOException e) {
            Log.error("Cannot open selector!", e);
            throw new RuntimeException(e);
        }
    }

    @Override
    protected final void beforeLoop() {
        this.validate();
        try {
            this.openSocket();
        }
        catch (IOException e) {
            throw U.rte("Cannot open socket!", e);
        }
    }

    private void validate() {
        U.must(this.net.workers() <= RapidoidWorker.MAX_IO_WORKERS, "Too many workers! Maximum = %s", RapidoidWorker.MAX_IO_WORKERS);
    }

    private void openSocket() throws IOException {
        U.notNull(this.net.protocol(), "protocol", new Object[0]);
        U.notNull(this.net.helperClass(), "helperClass", new Object[0]);
        String blockingInfo = this.net.blockingAccept() ? "blocking" : "non-blocking";
        Log.debug("Initializing server", "address", this.net.address(), "port", this.net.port(), "sync", this.net.syncBufs(), "accept", blockingInfo);
        this.serverSocketChannel = ServerSocketChannel.open();
        if (this.serverSocketChannel.isOpen() && this.selector.isOpen()) {
            this.serverSocketChannel.configureBlocking(this.net.blockingAccept());
            ServerSocket socket = this.serverSocketChannel.socket();
            Log.info("!Starting server", "!address", this.net.address(), "!port", this.net.port(), "I/O workers", this.net.workers(), "sync", this.net.syncBufs(), "accept", blockingInfo);
            InetSocketAddress addr = new InetSocketAddress(this.net.address(), this.net.port());
            socket.setReceiveBufferSize(16384);
            socket.setReuseAddress(true);
            socket.bind(addr, 16384);
            Log.debug("Opened server socket", "address", addr);
            if (!this.net.blockingAccept()) {
                Log.debug("Registering accept selector");
                this.serverSocketChannel.register(this.selector, 16);
            }
        } else {
            throw U.rte("Cannot open socket!");
        }
        this.initWorkers();
    }

    private void initWorkers() {
        this.ioWorkers = new RapidoidWorker[this.net.workers()];
        for (int i = 0; i < this.ioWorkers.length; ++i) {
            RapidoidWorkerThread workerThread = new RapidoidWorkerThread(i, this.net, this.sslContext);
            workerThread.start();
            this.ioWorkers[i] = workerThread.getWorker();
            if (i <= 0) continue;
            this.ioWorkers[i - 1].next = this.ioWorkers[i];
        }
        this.ioWorkers[this.ioWorkers.length - 1].next = this.ioWorkers[0];
        this.currentWorker = this.ioWorkers[0];
        for (RapidoidWorker worker : this.ioWorkers) {
            worker.waitToStart();
        }
    }

    @Override
    public synchronized Server start() {
        new RapidoidThread(this, "server").start();
        this.waitForStatusOtherThan(LoopStatus.INIT, LoopStatus.BEFORE_LOOP);
        if (this.status == LoopStatus.FAILED) {
            throw U.rte("Server start-up failed!");
        }
        return (Server)super.start();
    }

    @Override
    public synchronized Server shutdown() {
        Log.info("Shutting down the server...");
        this.stopLoop();
        if (this.ioWorkers != null) {
            for (RapidoidWorker worker : this.ioWorkers) {
                worker.shutdown();
            }
        }
        if (this.serverSocketChannel != null && this.selector != null && this.serverSocketChannel.isOpen() && this.selector.isOpen()) {
            try {
                this.selector.close();
                this.serverSocketChannel.close();
            }
            catch (IOException e) {
                Log.warn("Cannot close socket or selector!", e);
            }
        }
        super.shutdown();
        Log.info("!The server is down.");
        return this;
    }

    public synchronized RapidoidConnection newConnection() {
        int rndWorker = Rnd.rnd(this.ioWorkers.length);
        return this.ioWorkers[rndWorker].newConnection(false);
    }

    public synchronized void process(RapidoidConnection conn) {
        conn.worker.process(conn);
    }

    @Override
    public synchronized String process(String input) {
        if (this.ioWorkers == null) {
            this.initWorkers();
        }
        RapidoidConnection conn = this.newConnection();
        conn.setInitial(false);
        conn.input.append(input);
        conn.setProtocol(this.net.protocol());
        this.process(conn);
        return conn.output.asText();
    }

    public Protocol getProtocol() {
        return this.net.protocol();
    }

    @Override
    public TCPServerInfo info() {
        return this;
    }

    @Override
    public long messagesProcessed() {
        long total = 0L;
        for (int i = 0; i < this.ioWorkers.length; ++i) {
            total += this.ioWorkers[i].getMessagesProcessed();
        }
        return total;
    }

    @Override
    protected void insideLoop() {
        if (this.net.blockingAccept()) {
            this.processBlocking();
        } else {
            this.processNonBlocking();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void processNonBlocking() {
        try {
            this.selector.select(50L);
        }
        catch (IOException e) {
            Log.error("Select failed!", e);
        }
        try {
            Set<SelectionKey> selectedKeys;
            Set<SelectionKey> set = selectedKeys = this.selector.selectedKeys();
            synchronized (set) {
                Iterator<SelectionKey> iter = selectedKeys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    this.acceptChannel((ServerSocketChannel)key.channel());
                }
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
    }

    private void processBlocking() {
        this.acceptChannel(this.serverSocketChannel);
    }

    private void acceptChannel(ServerSocketChannel serverChannel) {
        try {
            SocketChannel channel = serverChannel.accept();
            this.currentWorker.accept(channel);
            this.currentWorker = this.currentWorker.next;
        }
        catch (IOException e) {
            Log.error("Acceptor error!", e);
        }
    }
}

