/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.channels.SelectionKey;
import java.nio.channels.SocketChannel;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.buffer.BufGroup;
import org.rapidoid.buffer.BufUtil;
import org.rapidoid.data.JSON;
import org.rapidoid.expire.Expiring;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.Log;
import org.rapidoid.net.AsyncLogic;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.abstracts.ChannelHolder;
import org.rapidoid.net.abstracts.IRequest;
import org.rapidoid.net.impl.ChannelHolderImpl;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.net.impl.CtxListener;
import org.rapidoid.net.impl.IgnorantConnectionListener;
import org.rapidoid.net.impl.NetWorker;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.net.tls.RapidoidTLS;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;
import org.rapidoid.util.Resetable;

public class RapidoidConnection
extends RapidoidThing
implements Resetable,
Channel,
Expiring,
Constants {
    private static final CtxListener IGNORE = new IgnorantConnectionListener();
    private static final AtomicLong ID_N = new AtomicLong();
    private static final AtomicLong SERIAL_N = new AtomicLong();
    final boolean hasTLS;
    final RapidoidTLS tls;
    final NetWorker worker;
    public final Buf input;
    public final Buf output;
    public final Buf outgoing;
    private final ConnState state = new ConnState();
    private volatile boolean waitingToWrite = false;
    public volatile SelectionKey key;
    private volatile boolean closeAfterWrite = false;
    volatile boolean closed = true;
    volatile boolean closing = false;
    volatile int completedInputPos;
    private volatile CtxListener listener;
    private final long serialN = SERIAL_N.incrementAndGet();
    private volatile long id;
    private volatile boolean initial;
    volatile boolean async;
    volatile boolean done;
    private volatile boolean isClient;
    private volatile Protocol protocol;
    volatile long requestId;
    final AtomicLong readSeq = new AtomicLong();
    final AtomicLong writeSeq = new AtomicLong();
    volatile boolean resumeInProgress = false;
    volatile IRequest request;
    private volatile long expiresAt;
    private volatile ChannelHolderImpl holder;
    public volatile int nextOp = 1;
    public volatile int mode = 0;
    private volatile boolean autoReconnect;

    public RapidoidConnection(NetWorker worker, BufGroup bufs) {
        this.worker = worker;
        this.hasTLS = worker.sslContext() != null;
        this.tls = this.hasTLS ? new RapidoidTLS(worker.sslContext(), this) : null;
        this.input = bufs.newBuf("input#" + this.serialN);
        this.output = bufs.newBuf("output#" + this.serialN);
        this.outgoing = this.hasTLS ? bufs.newBuf("outgoing#" + this.serialN) : this.output;
        this.reset();
    }

    @Override
    public synchronized void reset() {
        IRequest req = this.request;
        if (req != null) {
            req.stop();
            this.request = null;
        }
        this.id = ID_N.incrementAndGet();
        this.key = null;
        this.closed = true;
        this.closing = false;
        this.input.clear();
        this.output.clear();
        this.outgoing.clear();
        this.closeAfterWrite = false;
        this.waitingToWrite = false;
        this.completedInputPos = 0;
        this.listener = IGNORE;
        this.initial = true;
        this.async = false;
        this.done = false;
        this.isClient = false;
        this.protocol = null;
        this.requestId = 0L;
        this.readSeq.set(0L);
        this.writeSeq.set(0L);
        this.expiresAt = 0L;
        this.state.reset();
        if (this.tls != null) {
            this.tls.reset();
        }
        this.holder = null;
        this.mode = 0;
        this.autoReconnect = false;
        this.nextOp = 1;
    }

    @Override
    public void log(String msg) {
        this.state().log(msg);
    }

    @Override
    public synchronized InetSocketAddress getAddress() {
        if (this.key == null) {
            return null;
        }
        SocketChannel socketChannel = (SocketChannel)this.key.channel();
        SocketAddress addr = socketChannel.socket().getRemoteSocketAddress();
        if (addr instanceof InetSocketAddress) {
            InetSocketAddress address = (InetSocketAddress)addr;
            return address;
        }
        throw new IllegalStateException("Cannot get remote address!");
    }

    @Override
    public synchronized Channel write(String s) {
        this.output.append(s);
        return this;
    }

    @Override
    public synchronized Channel writeln(String s) {
        this.output.append(s);
        this.output.append(CR_LF);
        return this;
    }

    @Override
    public synchronized Channel write(byte[] bytes) {
        return this.write(bytes, 0, bytes.length);
    }

    @Override
    public synchronized Channel write(byte[] bytes, int offset, int length) {
        this.output.append(bytes, offset, length);
        return this;
    }

    @Override
    public synchronized Channel write(ByteBuffer buf) {
        this.output.append(buf);
        return this;
    }

    @Override
    public synchronized Channel write(File file) {
        try {
            FileInputStream stream = new FileInputStream(file);
            FileChannel fileChannel = stream.getChannel();
            this.output.append(fileChannel);
            stream.close();
        }
        catch (IOException e) {
            throw U.rte(e);
        }
        return this;
    }

    @Override
    public Channel writeJSON(Object value) {
        JSON.stringify(value, this.output.asOutputStream());
        return this;
    }

    public boolean closeAfterWrite() {
        return this.closeAfterWrite;
    }

    Channel done() {
        this.async = false;
        if (!this.done) {
            this.done = true;
            this.askToSend();
        }
        return this;
    }

    void processedSeq(long processedHandle) {
        long writeSeqN;
        if (processedHandle == 0L) {
            return;
        }
        U.must(processedHandle > 0L);
        boolean increased = this.writeSeq.compareAndSet(processedHandle - 1L, processedHandle);
        if (!increased && (writeSeqN = this.writeSeq.get()) != processedHandle) {
            throw U.rte("Error in the response order control! Expected handle: %s, real: %s", processedHandle - 1L, writeSeqN);
        }
    }

    @Override
    public Channel send() {
        this.askToSend();
        return this;
    }

    public void error() {
        this.askToSend();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized void askToSend() {
        Buf buf = this.outgoing;
        synchronized (buf) {
            if (this.hasTLS) {
                Buf buf2 = this.output;
                synchronized (buf2) {
                    this.tls.wrapToOutgoing();
                }
            }
            if (!this.waitingToWrite && this.outgoing.size() > 0) {
                this.waitingToWrite = true;
                this.worker.wantToWrite(this);
            }
        }
    }

    public synchronized void close(boolean waitToWrite) {
        if (waitToWrite) {
            this.done();
        }
        if (waitToWrite && this.waitingToWrite) {
            this.closeAfterWrite = true;
        } else {
            this.worker.close(this);
        }
    }

    synchronized void wrote(boolean complete) {
        if (complete) {
            this.waitingToWrite = false;
        }
        this.input.deleteBefore(this.completedInputPos);
        this.completedInputPos = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void resume(final long expectedConnId, final long handle, final AsyncLogic asyncLogic) {
        if (expectedConnId != this.connId()) {
            return;
        }
        long seq = this.writeSeq.get();
        if (seq < handle - 1L) {
            Jobs.execute(new Runnable(){

                @Override
                public void run() {
                    RapidoidConnection.this.resume(expectedConnId, handle, asyncLogic);
                }

                public String toString() {
                    return U.frmt("RapidoidConnection.ResumeJob(handle=%s, expectedConnId=%s, logic=%s)", handle, expectedConnId, asyncLogic);
                }
            });
        } else {
            if (seq == handle - 1L) {
                RapidoidConnection rapidoidConnection = this;
                synchronized (rapidoidConnection) {
                    if (expectedConnId != this.connId()) {
                        return;
                    }
                    this.resumeInProgress = true;
                    try {
                        this.doResume(handle, asyncLogic, seq);
                    }
                    finally {
                        this.resumeInProgress = false;
                    }
                }
            }
            Log.error("Tried to resume a job that already has finished!", "handle", handle, "currentHandle", seq, "job", asyncLogic);
            throw U.rte("Tried to resume a job that already has finished!");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doResume(long handle, AsyncLogic asyncLogic, long seq) {
        U.must(seq == this.writeSeq.get());
        boolean finished = false;
        Buf buf = this.output;
        synchronized (buf) {
            BufUtil.startWriting(this.output);
            try {
                finished = asyncLogic.resumeAsync();
            }
            catch (Throwable e) {
                Log.error("Error while resuming an asynchronous operation!", e);
            }
            BufUtil.doneWriting(this.output);
        }
        if (finished) {
            this.processedSeq(handle);
        }
    }

    @Override
    public Buf input() {
        return this.input;
    }

    @Override
    public Buf output() {
        return this.output;
    }

    @Override
    public OutputStream outputStream() {
        return this.output.asOutputStream();
    }

    @Override
    public boolean onSameThread() {
        return this.worker.onSameThread();
    }

    @Override
    public RapidoidHelper helper() {
        return this.worker.helper();
    }

    public CtxListener listener() {
        return this.listener;
    }

    public void setListener(CtxListener listener) {
        this.listener = listener;
    }

    @Override
    public String address() {
        InetSocketAddress inetSocketAddress = this.getAddress();
        return inetSocketAddress != null ? inetSocketAddress.getAddress().getHostAddress() : null;
    }

    @Override
    public Channel close() {
        this.close(true);
        return this;
    }

    @Override
    public Channel closeIf(boolean condition) {
        if (condition) {
            this.close();
        }
        return this;
    }

    @Override
    public String readln() {
        return this.input().readLn();
    }

    @Override
    public String readN(int count) {
        return this.input().readN(count);
    }

    @Override
    public ConnState state() {
        return this.state;
    }

    @Override
    public long handle() {
        return this.readSeq.get();
    }

    @Override
    public boolean isInitial() {
        return this.initial;
    }

    public String toString() {
        return "conn#" + this.connId();
    }

    public void setInitial(boolean initial) {
        this.initial = initial;
    }

    @Override
    public synchronized long async() {
        U.must(this.onSameThread(), "The connection can be marked as 'async' only on its I/O worker thread!");
        this.async = true;
        this.done = false;
        return this.handle();
    }

    @Override
    public synchronized boolean isAsync() {
        return this.async;
    }

    public boolean isClient() {
        return this.isClient;
    }

    public void setClient(boolean isClient) {
        this.isClient = isClient;
    }

    public void setProtocol(Protocol protocol) {
        this.protocol = protocol;
    }

    public Protocol getProtocol() {
        return this.protocol;
    }

    @Override
    public boolean isClosing() {
        return this.closing;
    }

    @Override
    public boolean isClosed() {
        return this.closed;
    }

    @Override
    public void waitUntilClosing() {
        if (!this.isClosing()) {
            throw Buf.INCOMPLETE_READ;
        }
    }

    @Override
    public long connId() {
        return this.id;
    }

    @Override
    public long requestId() {
        return this.requestId;
    }

    @Override
    public void setRequest(IRequest request) {
        this.request = request;
    }

    @Override
    public void setExpiresAt(long expiresAt) {
        this.expiresAt = expiresAt;
    }

    @Override
    public long getExpiresAt() {
        return this.expiresAt;
    }

    @Override
    public void expire() {
        this.close(false);
    }

    public boolean finishedWriting() {
        return this.outgoing.size() == 0;
    }

    public ChannelHolderImpl holder() {
        return this.holder;
    }

    public RapidoidConnection holder(ChannelHolderImpl holder) {
        this.holder = holder;
        return this;
    }

    public int nextOp() {
        return this.nextOp;
    }

    @Override
    public RapidoidConnection nextOp(int nextOp) {
        this.nextOp = nextOp;
        return this;
    }

    public int mode() {
        return this.mode;
    }

    @Override
    public RapidoidConnection mode(int mode) {
        this.mode = mode;
        return this;
    }

    public boolean autoReconnect() {
        return this.autoReconnect;
    }

    public RapidoidConnection autoReconnect(boolean autoReconnect) {
        this.autoReconnect = autoReconnect;
        return this;
    }

    @Override
    public Channel restart() {
        return null;
    }

    @Override
    public ChannelHolder createHolder() {
        return null;
    }

    @Override
    public Channel nextWrite() {
        return null;
    }

    public ChannelHolderImpl getHolder() {
        return this.holder;
    }

    public void setHolder(ChannelHolderImpl holder) {
        this.holder = holder;
    }
}

