/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import org.rapidoid.RapidoidThing;
import org.rapidoid.log.LogHP;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.abstracts.Channel;
import org.rapidoid.net.impl.ConnState;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;

public abstract class FiniteStateProtocol
extends RapidoidThing
implements Constants,
Protocol {
    private static final int MAX_STATES = 20;
    protected static final int STOP = -1;
    private final int statesCount;

    public FiniteStateProtocol(int statesCount) {
        U.must(statesCount > 0 && statesCount < 20, "Unsupported number of states: %s", statesCount);
        this.statesCount = statesCount;
    }

    @Override
    public final void process(Channel ctx) {
        int nextState;
        ConnState state = ctx.state();
        U.must(state.n != -1L, "The protocol was terminated!");
        U.must(state.n >= 0L && state.n < (long)this.statesCount, "Invalid state number!");
        int stateN = (int)state.n;
        switch (stateN) {
            case 0: {
                nextState = this.state0(ctx);
                break;
            }
            case 1: {
                nextState = this.state1(ctx);
                break;
            }
            case 2: {
                nextState = this.state2(ctx);
                break;
            }
            case 3: {
                nextState = this.state3(ctx);
                break;
            }
            case 4: {
                nextState = this.state4(ctx);
                break;
            }
            case 5: {
                nextState = this.state5(ctx);
                break;
            }
            case 6: {
                nextState = this.state6(ctx);
                break;
            }
            case 7: {
                nextState = this.state7(ctx);
                break;
            }
            case 8: {
                nextState = this.state8(ctx);
                break;
            }
            case 9: {
                nextState = this.state9(ctx);
                break;
            }
            case 10: {
                nextState = this.state10(ctx);
                break;
            }
            case 11: {
                nextState = this.state11(ctx);
                break;
            }
            case 12: {
                nextState = this.state12(ctx);
                break;
            }
            case 13: {
                nextState = this.state13(ctx);
                break;
            }
            case 14: {
                nextState = this.state14(ctx);
                break;
            }
            case 15: {
                nextState = this.state15(ctx);
                break;
            }
            case 16: {
                nextState = this.state16(ctx);
                break;
            }
            case 17: {
                nextState = this.state17(ctx);
                break;
            }
            case 18: {
                nextState = this.state18(ctx);
                break;
            }
            case 19: {
                nextState = this.state19(ctx);
                break;
            }
            default: {
                throw U.rte("Cannot handle state: " + stateN);
            }
        }
        if (state.n == -1L) {
            LogHP.debug("Terminating protocol", "from", state.n);
        } else {
            LogHP.debug("Switching protocol state", "from", state.n, "to", (long)nextState);
        }
        state.n = nextState;
    }

    protected int state0(Channel ctx) {
        throw U.rte("State 0 handler is not implemented!");
    }

    protected int state1(Channel ctx) {
        throw U.rte("State 1 handler is not implemented!");
    }

    protected int state2(Channel ctx) {
        throw U.rte("State 2 handler is not implemented!");
    }

    protected int state3(Channel ctx) {
        throw U.rte("State 3 handler is not implemented!");
    }

    protected int state4(Channel ctx) {
        throw U.rte("State 4 handler is not implemented!");
    }

    protected int state5(Channel ctx) {
        throw U.rte("State 5 handler is not implemented!");
    }

    protected int state6(Channel ctx) {
        throw U.rte("State 6 handler is not implemented!");
    }

    protected int state7(Channel ctx) {
        throw U.rte("State 7 handler is not implemented!");
    }

    protected int state8(Channel ctx) {
        throw U.rte("State 8 handler is not implemented!");
    }

    protected int state9(Channel ctx) {
        throw U.rte("State 9 handler is not implemented!");
    }

    protected int state10(Channel ctx) {
        throw U.rte("State 10 handler is not implemented!");
    }

    protected int state11(Channel ctx) {
        throw U.rte("State 11 handler is not implemented!");
    }

    protected int state12(Channel ctx) {
        throw U.rte("State 12 handler is not implemented!");
    }

    protected int state13(Channel ctx) {
        throw U.rte("State 13 handler is not implemented!");
    }

    protected int state14(Channel ctx) {
        throw U.rte("State 14 handler is not implemented!");
    }

    protected int state15(Channel ctx) {
        throw U.rte("State 15 handler is not implemented!");
    }

    protected int state16(Channel ctx) {
        throw U.rte("State 16 handler is not implemented!");
    }

    protected int state17(Channel ctx) {
        throw U.rte("State 17 handler is not implemented!");
    }

    protected int state18(Channel ctx) {
        throw U.rte("State 18 handler is not implemented!");
    }

    protected int state19(Channel ctx) {
        throw U.rte("State 19 handler is not implemented!");
    }
}

