/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import org.rapidoid.activity.LifecycleActivity;
import org.rapidoid.commons.Arr;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.LoopStatus;
import org.rapidoid.u.U;

public abstract class AbstractLoop<T>
extends LifecycleActivity<T>
implements Runnable {
    protected volatile Thread ownerThread;
    protected volatile LoopStatus status = LoopStatus.INIT;

    public AbstractLoop(String name) {
        super(name);
    }

    public LoopStatus status() {
        return this.status;
    }

    @Override
    public void run() {
        this.ownerThread = Thread.currentThread();
        Log.debug("Starting event loop", "name", this.name);
        this.setStatus(LoopStatus.BEFORE_LOOP);
        try {
            this.beforeLoop();
        }
        catch (Throwable e) {
            Log.error("Error occurred before loop is started", "name", this.name, "error", e);
            this.setStatus(LoopStatus.FAILED);
            return;
        }
        this.setStatus(LoopStatus.LOOP);
        while (this.status == LoopStatus.LOOP && !Thread.currentThread().isInterrupted()) {
            try {
                this.insideLoop();
            }
            catch (Throwable e) {
                Log.error("Event loop exception in " + this.name, e);
            }
        }
        this.setStatus(LoopStatus.AFTER_LOOP);
        this.afterLoop();
        this.setStatus(LoopStatus.STOPPED);
        Log.debug("Stopped event loop", "name", this.name);
    }

    private void setStatus(LoopStatus status) {
        this.status = status;
    }

    protected synchronized void stopLoop() {
        Log.debug("Stopping event loop", "name", this.name);
        while (this.status == LoopStatus.INIT || this.status == LoopStatus.BEFORE_LOOP) {
            try {
                Thread.sleep(10L);
                Log.debug("Waiting for event loop to initialize...", "name", this.name);
            }
            catch (InterruptedException interruptedException) {}
        }
        if (this.status == LoopStatus.LOOP) {
            this.status = LoopStatus.STOPPED;
        }
        Log.debug("Stopped event loop", "name", this.name);
    }

    protected void beforeLoop() {
    }

    protected abstract void insideLoop();

    protected void afterLoop() {
    }

    protected void assertStatus(LoopStatus expected) {
        if (this.status != expected) {
            throw new IllegalStateException("Expected status=" + (Object)((Object)expected) + " for event loop: " + this.name);
        }
    }

    public boolean onSameThread() {
        return this.ownerThread == Thread.currentThread();
    }

    protected void checkOnSameThread() {
        if (!this.onSameThread()) {
            throw U.rte("Not on the owner thread, expected %s, but found: %s", this.ownerThread, Thread.currentThread());
        }
    }

    @Override
    public T start() {
        super.start();
        this.waitToStart();
        return (T)this;
    }

    public void waitForStatus(LoopStatus ... requiredStatuses) {
        while (!Arr.contains(requiredStatuses, this.status)) {
            U.sleep(5L);
        }
    }

    public void waitForStatusOtherThan(LoopStatus ... requiredStatuses) {
        while (Arr.contains(requiredStatuses, this.status)) {
            U.sleep(5L);
        }
    }

    public void waitToStart() {
        this.waitForStatusOtherThan(LoopStatus.INIT, LoopStatus.BEFORE_LOOP);
    }

    @Override
    public T shutdown() {
        super.shutdown();
        this.waitToStop();
        return (T)this;
    }

    public void waitToStop() {
        this.waitForStatus(LoopStatus.STOPPED, LoopStatus.FAILED);
    }
}

