/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net.impl;

import java.io.IOException;
import java.nio.channels.ClosedSelectorException;
import java.nio.channels.SelectionKey;
import java.nio.channels.Selector;
import java.util.Iterator;
import java.util.Set;
import org.rapidoid.log.Log;
import org.rapidoid.net.impl.AbstractLoop;
import org.rapidoid.u.U;

public abstract class AbstractEventLoop<T>
extends AbstractLoop<T> {
    protected final Selector selector;
    protected volatile long approxTime = U.time();

    public AbstractEventLoop(String name) {
        super(name);
        Selector sel;
        try {
            sel = Selector.open();
        }
        catch (IOException e) {
            Log.error("Cannot open selector!", e);
            throw new RuntimeException(e);
        }
        this.selector = sel;
    }

    private void processKey(SelectionKey key) {
        if (key == null || !key.isValid()) {
            return;
        }
        if (key.isAcceptable()) {
            Log.trace("accepting", "key", key);
            try {
                this.acceptOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error("accept IO error for key: " + key, e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error("accept failed for key: " + key, e);
            }
        } else if (key.isConnectable()) {
            Log.trace("connection event", "key", key);
            try {
                this.connectOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error("connect IO error for key: " + key, e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error("connect failed for key: " + key, e);
            }
        } else if (key.isReadable()) {
            Log.trace("reading", "key", key);
            try {
                this.readOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error("read IO error for key: " + key, e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error("read failed for key: " + key, e);
            }
        } else if (key.isWritable()) {
            Log.trace("writing", "key", key);
            try {
                this.writeOP(key);
            }
            catch (IOException e) {
                this.failedOP(key, e);
                Log.error("write IO error for key: " + key, e);
            }
            catch (Throwable e) {
                this.failedOP(key, e);
                Log.error("write failed for key: " + key, e);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final void insideLoop() {
        this.approxTime = U.time();
        try {
            this.doProcessing();
        }
        catch (Throwable e) {
            Log.error("Event processing error!", e);
        }
        try {
            this.selector.select(this.getSelectorTimeout());
        }
        catch (IOException e) {
            Log.error("Select failed!", e);
        }
        this.approxTime = U.time();
        try {
            Set<SelectionKey> selectedKeys;
            Set<SelectionKey> set = selectedKeys = this.selector.selectedKeys();
            synchronized (set) {
                Iterator<SelectionKey> iter = selectedKeys.iterator();
                while (iter.hasNext()) {
                    SelectionKey key = iter.next();
                    iter.remove();
                    this.processKey(key);
                }
            }
        }
        catch (ClosedSelectorException closedSelectorException) {
            // empty catch block
        }
    }

    protected long getSelectorTimeout() {
        return 10L;
    }

    protected abstract void doProcessing();

    protected void acceptOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Accept operation is not implemented!");
    }

    protected void connectOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Connect operation is not implemented!");
    }

    protected void readOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Accept operation is not implemented!");
    }

    protected void writeOP(SelectionKey key) throws IOException {
        throw new RuntimeException("Accept operation is not implemented!");
    }

    protected void failedOP(SelectionKey key, Throwable e) {
    }
}

