/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net;

import javax.net.ssl.SSLContext;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.net.tls.TLSUtil;
import org.rapidoid.util.MscOpts;

public class TLSParams
extends RapidoidThing {
    private volatile boolean tls = MscOpts.isTLSEnabled();
    private volatile String keystore = Conf.TLS.entry("keystore").or("");
    private volatile char[] keystorePassword = Conf.TLS.entry("keystorePassword").or("").toCharArray();
    private volatile char[] keyManagerPassword = Conf.TLS.entry("keyManagerPassword").or("").toCharArray();
    private volatile String truststore = Conf.TLS.entry("truststore").or("");
    private volatile char[] truststorePassword = Conf.TLS.entry("truststorePassword").or("").toCharArray();
    private volatile boolean selfSignedTLS = Conf.TLS.is("selfSigned");
    private volatile SSLContext tlsContext;

    public boolean tls() {
        return this.tls;
    }

    public TLSParams tls(boolean tls) {
        this.tls = tls;
        return this;
    }

    public String keystore() {
        return this.keystore;
    }

    public TLSParams keystore(String keystore) {
        this.keystore = keystore;
        return this;
    }

    public char[] keystorePassword() {
        return this.keystorePassword;
    }

    public TLSParams keystorePassword(char[] keystorePassword) {
        this.keystorePassword = keystorePassword;
        return this;
    }

    public char[] keyManagerPassword() {
        return this.keyManagerPassword;
    }

    public TLSParams keyManagerPassword(char[] keyManagerPassword) {
        this.keyManagerPassword = keyManagerPassword;
        return this;
    }

    public String truststore() {
        return this.truststore;
    }

    public TLSParams truststore(String truststore) {
        this.truststore = truststore;
        return this;
    }

    public char[] truststorePassword() {
        return this.truststorePassword;
    }

    public TLSParams truststorePassword(char[] truststorePassword) {
        this.truststorePassword = truststorePassword;
        return this;
    }

    public boolean selfSignedTLS() {
        return this.selfSignedTLS;
    }

    public TLSParams selfSignedTLS(boolean selfSignedTLS) {
        this.selfSignedTLS = selfSignedTLS;
        return this;
    }

    public SSLContext tlsContext() {
        return this.tlsContext;
    }

    public TLSParams tlsContext(SSLContext tlsContext) {
        this.tlsContext = tlsContext;
        return this;
    }

    public synchronized SSLContext buildTLSContext() {
        if (this.tls && this.tlsContext == null) {
            this.tlsContext = TLSUtil.createContext(this.keystore, this.keystorePassword, this.keyManagerPassword, this.truststore, this.truststorePassword, this.selfSignedTLS);
        }
        return this.tls ? this.tlsContext : null;
    }
}

