/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net;

import javax.net.ssl.SSLContext;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.net.NetworkingParams;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.TCPClient;
import org.rapidoid.net.TLSParams;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.impl.RapidoidClientLoop;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.u.U;

public class TCPClientBuilder
extends RapidoidThing {
    private volatile int connections;
    private volatile boolean reconnecting = true;
    private final NetworkingParams netParams;
    private final TLSParams tlsParams = new TLSParams();
    private volatile boolean built;

    public TCPClientBuilder(BasicConfig cfg) {
        this.netParams = new NetworkingParams(cfg);
    }

    public TCPClientBuilder host(String host) {
        this.netParams.address(host);
        return this;
    }

    public TCPClientBuilder port(int port) {
        this.netParams.port(port);
        return this;
    }

    public TCPClientBuilder workers(int workers) {
        this.netParams.workers(workers);
        return this;
    }

    public TCPClientBuilder bufSizeKB(int bufSizeKB) {
        this.netParams.bufSizeKB(bufSizeKB);
        return this;
    }

    public TCPClientBuilder noDelay(boolean noDelay) {
        this.netParams.noDelay(noDelay);
        return this;
    }

    public TCPClientBuilder maxPipeline(long maxPipelineSize) {
        this.netParams.maxPipeline(maxPipelineSize);
        return this;
    }

    public TCPClientBuilder syncBufs(boolean syncBufs) {
        this.netParams.syncBufs(syncBufs);
        return this;
    }

    public TCPClientBuilder blockingAccept(boolean blockingAccept) {
        this.netParams.blockingAccept(blockingAccept);
        return this;
    }

    public TCPClientBuilder protocol(Protocol protocol) {
        this.netParams.protocol(protocol);
        return this;
    }

    public TCPClientBuilder exchangeClass(Class<? extends DefaultExchange<?>> exchangeClass) {
        this.netParams.exchangeClass(exchangeClass);
        return this;
    }

    public TCPClientBuilder helperClass(Class<? extends RapidoidHelper> helperClass) {
        this.netParams.helperClass(helperClass);
        return this;
    }

    public TCPClientBuilder tls(boolean tls) {
        this.tlsParams.tls(tls);
        return this;
    }

    public TCPClientBuilder keystore(String keystore) {
        this.tlsParams.keystore(keystore);
        return this;
    }

    public TCPClientBuilder keystorePassword(char[] keystorePassword) {
        this.tlsParams.keystorePassword(keystorePassword);
        return this;
    }

    public TCPClientBuilder keyManagerPassword(char[] keyManagerPassword) {
        this.tlsParams.keyManagerPassword(keyManagerPassword);
        return this;
    }

    public TCPClientBuilder truststore(String truststore) {
        this.tlsParams.truststore(truststore);
        return this;
    }

    public TCPClientBuilder truststorePassword(char[] truststorePassword) {
        this.tlsParams.truststorePassword(truststorePassword);
        return this;
    }

    public TCPClientBuilder selfSignedTLS(boolean selfSignedTLS) {
        this.tlsParams.selfSignedTLS(selfSignedTLS);
        return this;
    }

    public TCPClientBuilder tlsContext(SSLContext tlsContext) {
        this.tlsParams.tlsContext(tlsContext);
        return this;
    }

    public TCPClientBuilder connections(int connections) {
        this.connections = connections;
        return this;
    }

    public TCPClientBuilder reconnecting(boolean reconnecting) {
        this.reconnecting = reconnecting;
        return this;
    }

    public synchronized TCPClient build() {
        U.must(!this.built, "This builder was already used! Please instantiate a new one!");
        this.built = true;
        return new RapidoidClientLoop(this.netParams, this.reconnecting, this.connections, this.tlsParams.buildTLSContext());
    }
}

