/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.net;

import javax.net.ssl.SSLContext;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.BasicConfig;
import org.rapidoid.net.NetworkingParams;
import org.rapidoid.net.Protocol;
import org.rapidoid.net.Server;
import org.rapidoid.net.TLSParams;
import org.rapidoid.net.impl.DefaultExchange;
import org.rapidoid.net.impl.RapidoidHelper;
import org.rapidoid.net.impl.RapidoidServerLoop;
import org.rapidoid.u.U;

public class ServerBuilder
extends RapidoidThing {
    private final NetworkingParams netParams;
    private final TLSParams tlsParams = new TLSParams();
    private volatile boolean built;

    public ServerBuilder(BasicConfig cfg) {
        this.netParams = new NetworkingParams(cfg);
    }

    public ServerBuilder address(String address) {
        this.netParams.address(address);
        return this;
    }

    public ServerBuilder port(int port) {
        this.netParams.port(port);
        return this;
    }

    public ServerBuilder workers(int workers) {
        this.netParams.workers(workers);
        return this;
    }

    public ServerBuilder bufSizeKB(int bufSizeKB) {
        this.netParams.bufSizeKB(bufSizeKB);
        return this;
    }

    public ServerBuilder noDelay(boolean noDelay) {
        this.netParams.noDelay(noDelay);
        return this;
    }

    public ServerBuilder maxPipeline(long maxPipelineSize) {
        this.netParams.maxPipeline(maxPipelineSize);
        return this;
    }

    public ServerBuilder syncBufs(boolean syncBufs) {
        this.netParams.syncBufs(syncBufs);
        return this;
    }

    public ServerBuilder blockingAccept(boolean blockingAccept) {
        this.netParams.blockingAccept(blockingAccept);
        return this;
    }

    public ServerBuilder protocol(Protocol protocol) {
        this.netParams.protocol(protocol);
        return this;
    }

    public ServerBuilder exchangeClass(Class<? extends DefaultExchange<?>> exchangeClass) {
        this.netParams.exchangeClass(exchangeClass);
        return this;
    }

    public ServerBuilder helperClass(Class<? extends RapidoidHelper> helperClass) {
        this.netParams.helperClass(helperClass);
        return this;
    }

    public ServerBuilder tls(boolean tls) {
        this.tlsParams.tls(tls);
        return this;
    }

    public ServerBuilder keystore(String keystore) {
        this.tlsParams.keystore(keystore);
        return this;
    }

    public ServerBuilder keystorePassword(char[] keystorePassword) {
        this.tlsParams.keystorePassword(keystorePassword);
        return this;
    }

    public ServerBuilder keyManagerPassword(char[] keyManagerPassword) {
        this.tlsParams.keyManagerPassword(keyManagerPassword);
        return this;
    }

    public ServerBuilder truststore(String truststore) {
        this.tlsParams.truststore(truststore);
        return this;
    }

    public ServerBuilder truststorePassword(char[] truststorePassword) {
        this.tlsParams.truststorePassword(truststorePassword);
        return this;
    }

    public ServerBuilder selfSignedTLS(boolean selfSignedTLS) {
        this.tlsParams.selfSignedTLS(selfSignedTLS);
        return this;
    }

    public ServerBuilder tlsContext(SSLContext tlsContext) {
        this.tlsParams.tlsContext(tlsContext);
        return this;
    }

    public synchronized Server build() {
        U.must(!this.built, "This builder was already used! Please instantiate a new one!");
        this.built = true;
        return new RapidoidServerLoop(this.netParams, this.tlsParams.buildTLSContext());
    }
}

