/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.job.JobExecutor;
import org.rapidoid.job.JobScheduler;
import org.rapidoid.job.Jobs;
import org.rapidoid.optional.Opt;
import org.rapidoid.util.LazyInit;
import org.rapidoid.util.Once;

public class JobsService
extends RapidoidInitializer {
    private final Once init = new Once();
    private final AtomicLong errorCounter = new AtomicLong();
    private final LazyInit<JobScheduler> scheduler = new LazyInit<JobScheduler>(JobScheduler.class);
    private final LazyInit<JobExecutor> executor = new LazyInit<JobExecutor>(JobExecutor.class);
    private final AtomicBoolean active = new AtomicBoolean(true);

    public synchronized void reset() {
        this.errorCounter.set(0L);
        this.executor.resetAndClose();
        this.scheduler.resetAndClose();
        this.active.set(true);
    }

    void init() {
        this.active.set(true);
        if (this.init.go()) {
            Runtime.getRuntime().addShutdownHook(new Thread(){

                @Override
                public void run() {
                    JobsService.this.shutdownNow();
                }
            });
        }
    }

    public boolean isActive() {
        return this.active.get();
    }

    public Opt<ThreadPoolExecutor> executor() {
        return Opt.maybe(this.isActive() ? this.executor.get().executor() : null);
    }

    public Opt<ScheduledThreadPoolExecutor> scheduler() {
        return Opt.maybe(this.isActive() ? this.scheduler.get().scheduler() : null);
    }

    public AtomicLong errorCounter() {
        return this.errorCounter;
    }

    public synchronized void shutdown() {
        Opt<ScheduledThreadPoolExecutor> sch;
        Opt<ThreadPoolExecutor> exe;
        this.active.set(false);
        if (this.executor.isInitialized() && (exe = this.executor()).exists()) {
            exe.get().shutdown();
            Jobs.awaitTermination(exe.get());
        }
        if (this.scheduler.isInitialized() && (sch = this.scheduler()).exists()) {
            sch.get().shutdown();
            Jobs.awaitTermination(sch.get());
        }
    }

    public synchronized void shutdownNow() {
        Opt<ScheduledThreadPoolExecutor> sch;
        Opt<ThreadPoolExecutor> exe;
        this.active.set(false);
        if (this.executor.isInitialized() && (exe = this.executor()).exists()) {
            exe.get().shutdownNow();
            Jobs.awaitTermination(exe.get());
        }
        if (this.scheduler.isInitialized() && (sch = this.scheduler()).exists()) {
            sch.get().shutdownNow();
            Jobs.awaitTermination(sch.get());
        }
    }
}

