/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.util.concurrent.Callable;
import java.util.concurrent.RejectedExecutionException;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.ctx.WithContext;
import org.rapidoid.job.CallbackExecutorJob;
import org.rapidoid.job.ContextPreservingJobWrapper;
import org.rapidoid.job.JobsDSL;
import org.rapidoid.job.JobsDelayDSL;
import org.rapidoid.job.JobsService;
import org.rapidoid.job.PredefinedContextJobWrapper;
import org.rapidoid.log.Log;
import org.rapidoid.optional.Opt;
import org.rapidoid.u.U;

public class Jobs
extends RapidoidInitializer {
    private static final JobsService jobs = new JobsService();

    private Jobs() {
    }

    public static synchronized void reset() {
        jobs.reset();
    }

    static void init() {
        jobs.init();
    }

    public static ThreadPoolExecutor executor() {
        return jobs.executor().get();
    }

    public static ScheduledThreadPoolExecutor scheduler() {
        return jobs.scheduler().get();
    }

    public static ScheduledFuture<?> schedule(Runnable job, long delay, TimeUnit unit) {
        return Jobs.requireActiveScheduler().schedule(Jobs.wrap(job), delay, unit);
    }

    public static <T> ScheduledFuture<?> schedule(Callable<T> job, long delay, TimeUnit unit, Callback<T> callback) {
        return Jobs.schedule(Jobs.callbackJob(job, callback), delay, unit);
    }

    public static ScheduledFuture<?> scheduleAtFixedRate(Runnable job, long initialDelay, long period, TimeUnit unit) {
        return Jobs.requireActiveScheduler().scheduleAtFixedRate(Jobs.wrap(job), initialDelay, period, unit);
    }

    public static <T> ScheduledFuture<?> scheduleAtFixedRate(Callable<T> job, long initialDelay, long period, TimeUnit unit, Callback<T> callback) {
        return Jobs.scheduleAtFixedRate(Jobs.callbackJob(job, callback), initialDelay, period, unit);
    }

    public static ScheduledFuture<?> scheduleWithFixedDelay(Runnable job, long initialDelay, long delay, TimeUnit unit) {
        return Jobs.requireActiveScheduler().scheduleWithFixedDelay(Jobs.wrap(job), initialDelay, delay, unit);
    }

    public static <T> ScheduledFuture<?> scheduleWithFixedDelay(Callable<T> job, long initialDelay, long delay, TimeUnit unit, Callback<T> callback) {
        return Jobs.scheduleWithFixedDelay(Jobs.callbackJob(job, callback), initialDelay, delay, unit);
    }

    public static void execute(Runnable job) {
        Opt<ThreadPoolExecutor> executor = jobs.executor();
        if (executor.exists()) {
            ContextPreservingJobWrapper jobWrapper = Jobs.wrap(job);
            try {
                executor.get().execute(jobWrapper);
            }
            catch (RejectedExecutionException e) {
                Log.warn("Job execution was rejected!", "job", job);
            }
        }
    }

    public static void executeAndWait(Runnable job) {
        Opt<ThreadPoolExecutor> executor = jobs.executor();
        if (executor.exists()) {
            ContextPreservingJobWrapper jobWrapper = Jobs.wrap(job);
            try {
                executor.get().execute(jobWrapper);
            }
            catch (RejectedExecutionException e) {
                Log.warn("Job execution was rejected!", "job", job);
            }
            while (!jobWrapper.isDone()) {
                U.sleep(10L);
            }
        }
    }

    public static <T> void execute(Callable<T> job, Callback<T> callback) {
        Jobs.execute(Jobs.callbackJob(job, callback));
    }

    public static ContextPreservingJobWrapper wrap(Runnable job) {
        Ctx ctx = Ctxs.get();
        if (ctx != null) {
            ctx = ctx.span();
        }
        return new ContextPreservingJobWrapper(job, ctx);
    }

    public static <T> void call(Callback<T> callback, T result, Throwable error) {
        Jobs.execute(new CallbackExecutorJob<T>(callback, result, error));
    }

    private static <T> Runnable callbackJob(final Callable<T> job, final Callback<T> callback) {
        return new Runnable(){

            @Override
            public void run() {
                Object result;
                try {
                    result = job.call();
                }
                catch (Throwable e) {
                    Jobs.call(callback, null, e);
                    return;
                }
                Jobs.call(callback, result, null);
            }
        };
    }

    public static void executeInContext(WithContext context, Runnable action) {
        Opt<ThreadPoolExecutor> executor = jobs.executor();
        if (executor.exists()) {
            try {
                executor.get().execute(new PredefinedContextJobWrapper(context, action));
            }
            catch (RejectedExecutionException e) {
                Log.warn("The job was rejected by the executor/scheduler!", "context", context.tag());
            }
        }
    }

    public static JobsDelayDSL after(long delay) {
        return new JobsDelayDSL(delay);
    }

    public static JobsDSL after(long delay, TimeUnit unit) {
        return new JobsDSL(delay, -1L, unit);
    }

    public static JobsDSL every(long period, TimeUnit unit) {
        return new JobsDSL(-1L, period, unit);
    }

    public static AtomicLong errorCounter() {
        return jobs.errorCounter();
    }

    public static synchronized void shutdown() {
        jobs.shutdown();
    }

    public static synchronized void shutdownNow() {
        jobs.shutdownNow();
    }

    private static ScheduledThreadPoolExecutor requireActiveScheduler() {
        return jobs.scheduler().orFail("The scheduler is not active!");
    }

    static void awaitTermination(ThreadPoolExecutor threadPoolExecutor) {
        try {
            threadPoolExecutor.awaitTermination(10L, TimeUnit.SECONDS);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
    }

    private static void executeWithRetriesOnReject(Runnable action) {
        int attempt = 0;
        while (true) {
            ++attempt;
            try {
                action.run();
            }
            catch (RejectedExecutionException e) {
                Log.warn("Job execution was rejected!", "attempt", attempt, "thread", Thread.currentThread().getName());
                try {
                    Thread.sleep(1L);
                }
                catch (InterruptedException e2) {
                    return;
                }
            }
        }
    }
}

