/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.job;

import java.util.concurrent.CancellationException;
import org.rapidoid.RapidoidThing;
import org.rapidoid.ctx.Ctx;
import org.rapidoid.ctx.Ctxs;
import org.rapidoid.job.Jobs;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;

public class ContextPreservingJobWrapper
extends RapidoidThing
implements Runnable {
    private final Runnable job;
    private final Ctx ctx;
    private volatile boolean done;

    public ContextPreservingJobWrapper(Runnable job, Ctx ctx) {
        this.job = job;
        this.ctx = ctx;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public void run() {
        block18: {
            Ctx existingCtx = Ctxs.get();
            if (existingCtx != null) {
                throw U.rte("Detected context leak! Found open context (%s) on thread: %s", existingCtx.tag(), Thread.currentThread().getName());
            }
            try {
                if (this.ctx != null) {
                    Ctxs.attach(this.ctx);
                } else {
                    Ctxs.open("job");
                    Log.debug("Opening new context");
                }
            }
            catch (CancellationException e) {
                Log.warn("Job context initialization was canceled!");
                this.done = true;
                return;
            }
            catch (Throwable e) {
                Jobs.errorCounter().incrementAndGet();
                Log.error("Job context initialization failed!", e);
                throw U.rte("Job context initialization failed!", e);
            }
            this.job.run();
            break block18;
            catch (CancellationException e) {
                Log.warn("Job execution was canceled!");
                this.done = true;
                return;
            }
            catch (Throwable e) {
                Jobs.errorCounter().incrementAndGet();
                Log.error("Job execution failed!", e);
                throw U.rte("Job execution failed!", e);
            }
            {
                finally {
                    Ctxs.close();
                }
            }
            {
                catch (Throwable throwable) {
                    throw throwable;
                }
            }
            finally {
                this.done = true;
            }
        }
    }

    public boolean isDone() {
        return this.done;
    }
}

