/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http.client;

import org.rapidoid.RapidoidThing;
import org.rapidoid.buffer.Buf;
import org.rapidoid.concurrent.Callbacks;
import org.rapidoid.concurrent.Promise;
import org.rapidoid.concurrent.Promises;
import org.rapidoid.data.BufRange;
import org.rapidoid.data.BufRanges;
import org.rapidoid.http.client.HttpClientCallback;

public class BlockingHttpClientCallback
extends RapidoidThing
implements HttpClientCallback {
    private final Promise<byte[]> promise = Promises.create();

    @Override
    public void onResult(Buf buffer, BufRanges head, BufRanges body) {
        BufRange whole = new BufRange();
        whole.start = head.ranges[0].start;
        whole.length = body.last().start + body.last().length;
        byte[] result = whole.bytes(buffer);
        Callbacks.done(this.promise, result, null);
    }

    @Override
    public void onError(Throwable error) {
        Callbacks.done(this.promise, null, error);
    }

    public byte[] getResponse() {
        return (byte[])this.promise.get();
    }
}

