/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.http.HTTP;
import org.rapidoid.http.HttpReq;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class Self
extends RapidoidThing {
    public static String localUrl(String urlPath) {
        U.must(urlPath.startsWith("/"), "Invalid URL path, it must start with '/'!");
        int port = Conf.ON.entry("port").or(8080);
        return Msc.http() + "://localhost:" + port + urlPath;
    }

    public static HttpReq req(HttpVerb verb, String urlPath) {
        return HTTP.req().verb(verb).url(Self.localUrl(urlPath));
    }

    public static HttpReq get(String urlPath) {
        return Self.req(HttpVerb.GET, urlPath);
    }

    public static HttpReq post(String urlPath) {
        return Self.req(HttpVerb.POST, urlPath);
    }

    public static HttpReq put(String urlPath) {
        return Self.req(HttpVerb.PUT, urlPath);
    }

    public static HttpReq delete(String urlPath) {
        return Self.req(HttpVerb.DELETE, urlPath);
    }

    public static HttpReq patch(String urlPath) {
        return Self.req(HttpVerb.PATCH, urlPath);
    }

    public static HttpReq options(String urlPath) {
        return Self.req(HttpVerb.OPTIONS, urlPath);
    }

    public static HttpReq head(String urlPath) {
        return Self.req(HttpVerb.HEAD, urlPath);
    }

    public static HttpReq trace(String urlPath) {
        return Self.req(HttpVerb.TRACE, urlPath);
    }
}

