/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.http.impl.nio.client.CloseableHttpAsyncClient;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Future;
import org.rapidoid.http.HttpClientUtil;
import org.rapidoid.http.HttpReq;
import org.rapidoid.http.HttpResp;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.log.Log;
import org.rapidoid.util.LazyInit;
import org.rapidoid.util.MscOpts;

public class HttpClient
extends RapidoidThing {
    private volatile String host = null;
    private volatile String userAgent = null;
    private volatile boolean followRedirects = false;
    private volatile boolean keepAlive = false;
    private volatile boolean keepCookies = false;
    private volatile boolean reuseConnections = false;
    private volatile boolean decompress = true;
    private volatile int maxConnPerRoute = 0;
    private volatile int maxConnTotal = 0;
    private volatile int maxRedirects = 5;
    private volatile boolean validateSSL = !MscOpts.isTLSEnabled();
    private volatile int timeout = 5000;
    private final Map<String, String> cookies = Coll.synchronizedMap();
    private final LazyInit<CloseableHttpAsyncClient> client = new LazyInit<CloseableHttpAsyncClient>(new Callable<CloseableHttpAsyncClient>(){

        @Override
        public CloseableHttpAsyncClient call() throws Exception {
            CloseableHttpAsyncClient client = HttpClientUtil.client(HttpClient.this);
            client.start();
            return client;
        }
    });

    public Future<HttpResp> executeRequest(HttpReq req, Callback<HttpResp> callback) {
        return HttpClientUtil.request(req, this.client.get(), callback, false);
    }

    public HttpClient userAgent(String userAgent) {
        this.userAgent = userAgent;
        return this;
    }

    public String userAgent() {
        return this.userAgent;
    }

    public HttpClient followRedirects(boolean followRedirects) {
        this.followRedirects = followRedirects;
        return this;
    }

    public boolean followRedirects() {
        return this.followRedirects;
    }

    public HttpClient keepAlive(boolean keepAlive) {
        this.keepAlive = keepAlive;
        return this;
    }

    public boolean keepAlive() {
        return this.keepAlive;
    }

    public HttpClient keepCookies(boolean keepCookies) {
        this.keepCookies = keepCookies;
        return this;
    }

    public boolean keepCookies() {
        return this.keepCookies;
    }

    public HttpClient reuseConnections(boolean reuseConnections) {
        this.reuseConnections = reuseConnections;
        return this;
    }

    public boolean reuseConnections() {
        return this.reuseConnections;
    }

    public HttpClient decompress(boolean decompress) {
        this.decompress = decompress;
        return this;
    }

    public boolean decompress() {
        return this.decompress;
    }

    public HttpClient maxConnPerRoute(int maxConnPerRoute) {
        this.maxConnPerRoute = maxConnPerRoute;
        return this;
    }

    public int maxConnPerRoute() {
        return this.maxConnPerRoute;
    }

    public HttpClient maxConnTotal(int maxConnTotal) {
        this.maxConnTotal = maxConnTotal;
        return this;
    }

    public int maxConnTotal() {
        return this.maxConnTotal;
    }

    public HttpClient maxRedirects(int maxRedirects) {
        this.maxRedirects = maxRedirects;
        return this;
    }

    public int maxRedirects() {
        return this.maxRedirects;
    }

    public boolean validateSSL() {
        return this.validateSSL;
    }

    public HttpClient validateSSL(boolean validateSSL) {
        this.validateSSL = validateSSL;
        return this;
    }

    public HttpClient cookie(String name, String value) {
        this.cookies().put(name, value);
        return this;
    }

    public String host() {
        return this.host;
    }

    public HttpClient host(String host) {
        this.host = host;
        return this;
    }

    public HttpClient cookies(Map<String, String> cookies) {
        Coll.assign(this.cookies, cookies);
        return this;
    }

    public Map<String, String> cookies() {
        return this.cookies;
    }

    public int timeout() {
        return this.timeout;
    }

    public HttpClient timeout(int timeout) {
        this.timeout = timeout;
        return this;
    }

    public HttpReq req() {
        return new HttpReq(this);
    }

    public HttpReq get(String url) {
        return this.req().verb(HttpVerb.GET).url(url);
    }

    public HttpReq post(String url) {
        return this.req().verb(HttpVerb.POST).url(url);
    }

    public HttpReq put(String url) {
        return this.req().verb(HttpVerb.PUT).url(url);
    }

    public HttpReq delete(String url) {
        return this.req().verb(HttpVerb.DELETE).url(url);
    }

    public HttpReq patch(String url) {
        return this.req().verb(HttpVerb.PATCH).url(url);
    }

    public HttpReq options(String url) {
        return this.req().verb(HttpVerb.OPTIONS).url(url);
    }

    public HttpReq head(String url) {
        return this.req().verb(HttpVerb.HEAD).url(url);
    }

    public HttpReq trace(String url) {
        return this.req().verb(HttpVerb.TRACE).url(url);
    }

    public synchronized void close() {
        try {
            this.client.resetAndClose();
        }
        catch (Exception e) {
            Log.error("Error while closing the HTTP client!", e);
        }
    }

    public synchronized void reset() {
        this.close();
    }
}

