/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.util.List;
import java.util.Map;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.http.HttpClient;
import org.rapidoid.http.HttpReq;
import org.rapidoid.http.HttpVerb;
import org.rapidoid.io.Upload;

public class HTTP
extends RapidoidInitializer {
    private static volatile HttpClient client = HTTP.client();
    public static final String CONTENT_TYPE_MULTIPART = "multipart/form-data";
    public static final String CONTENT_TYPE_FORM_URLENCODED = "application/x-www-form-urlencoded";
    public static final String CONTENT_TYPE_JSON = "application/json";
    public static final String CONTENT_TYPE_XML = "application/xml";
    public static final String CONTENT_TYPE_BINARY = "application/octet-stream";

    public static HttpClient client() {
        return new HttpClient();
    }

    public static HttpReq req() {
        return client.req();
    }

    public static HttpReq get(String url) {
        return HTTP.req().verb(HttpVerb.GET).url(url);
    }

    public static HttpReq post(String url) {
        return HTTP.req().verb(HttpVerb.POST).url(url);
    }

    public static HttpReq put(String url) {
        return HTTP.req().verb(HttpVerb.PUT).url(url);
    }

    public static HttpReq delete(String url) {
        return HTTP.req().verb(HttpVerb.DELETE).url(url);
    }

    public static HttpReq patch(String url) {
        return HTTP.req().verb(HttpVerb.PATCH).url(url);
    }

    public static HttpReq options(String url) {
        return HTTP.req().verb(HttpVerb.OPTIONS).url(url);
    }

    public static HttpReq head(String url) {
        return HTTP.req().verb(HttpVerb.HEAD).url(url);
    }

    public static HttpReq trace(String url) {
        return HTTP.req().verb(HttpVerb.TRACE).url(url);
    }

    public static HttpReq verb(HttpVerb verb) {
        return HTTP.req().verb(verb);
    }

    public static HttpReq url(String url) {
        return HTTP.req().url(url);
    }

    public static HttpReq body(byte[] body) {
        return HTTP.req().body(body);
    }

    public static HttpReq headers(Map<String, String> headers) {
        return HTTP.req().headers(headers);
    }

    public static HttpReq data(Map<String, String> data) {
        return HTTP.req().data(data);
    }

    public static HttpReq files(Map<String, List<Upload>> files) {
        return HTTP.req().files(files);
    }

    public static HttpReq contentType(String contentType) {
        return HTTP.req().contentType(contentType);
    }

    public static HttpReq socketTimeout(int socketTimeout) {
        return HTTP.req().socketTimeout(socketTimeout);
    }

    public static HttpReq connectTimeout(int connectTimeout) {
        return HTTP.req().connectTimeout(connectTimeout);
    }

    public static HttpReq connectionRequestTimeout(int connectionRequestTimeout) {
        return HTTP.req().connectionRequestTimeout(connectionRequestTimeout);
    }

    public static HttpReq raw(boolean raw) {
        return HTTP.req().raw(raw);
    }

    public static synchronized void close() {
        HttpClient oldClient = client;
        client = HTTP.client();
        oldClient.close();
    }
}

