/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.http;

import java.lang.annotation.Annotation;
import java.lang.reflect.Method;
import org.rapidoid.RapidoidThing;
import org.rapidoid.annotation.OfType;
import org.rapidoid.beany.Metadata;
import org.rapidoid.commons.Arr;
import org.rapidoid.concurrent.Callback;
import org.rapidoid.concurrent.Future;
import org.rapidoid.config.Conf;
import org.rapidoid.config.Config;
import org.rapidoid.http.REST;
import org.rapidoid.lambda.Dynamic;
import org.rapidoid.u.U;
import org.rapidoid.util.Constants;

public class DynamicRESTClient
extends RapidoidThing
implements Dynamic {
    private final Class<?> clientInterface;
    private final Config config;

    public DynamicRESTClient(Class<?> clientInterface) {
        this(clientInterface, Conf.section(clientInterface));
    }

    public DynamicRESTClient(Class<?> clientInterface, Config config) {
        this.clientInterface = clientInterface;
        this.config = config;
    }

    @Override
    public Object call(Method m, Object[] args) {
        U.must(!this.config.isEmpty(), "Cannot find configuration for the REST client interface: %s", this.clientInterface.getSimpleName());
        Config cfg = this.config.sub(m.getName());
        String verb = this.verbOf(cfg);
        String url = cfg.entry(verb).str().get();
        U.must(!U.isEmpty(verb), "The [verb: url] entry is not configured for the method: %s", m);
        U.must(!U.isEmpty(url), "Cannot find 'url' configuration for the method: %s", m);
        Class<?> retType = m.getReturnType();
        Class<?>[] paramTypes = m.getParameterTypes();
        Class<?> lastParamType = U.last(paramTypes);
        if (lastParamType != null && Callback.class.isAssignableFrom(lastParamType)) {
            U.must(retType.equals(Void.TYPE) || java.util.concurrent.Future.class.isAssignableFrom(retType) || Future.class.isAssignableFrom(retType));
            Callback callback = (Callback)U.last(args);
            U.notNull(callback, "callback", new Object[0]);
            args = Arr.sub(args, 0, -1);
            String realUrl = String.format(url, args);
            OfType ofType = Metadata.get((Annotation[])U.last(m.getParameterAnnotations()), OfType.class);
            Class resultType = ofType != null ? ofType.value() : Object.class;
            return REST.call(verb, realUrl, resultType, callback);
        }
        String realUrl = String.format(url, args);
        return REST.call(verb, realUrl, retType);
    }

    private String verbOf(Config cfg) {
        for (String verb : Constants.HTTP_VERBS) {
            if (!cfg.has(verb)) continue;
            return verb;
        }
        return null;
    }
}

