/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.group;

import java.util.Collections;
import java.util.List;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.group.GroupStats;
import org.rapidoid.group.Groups;
import org.rapidoid.group.Manageable;
import org.rapidoid.group.Manageables;
import org.rapidoid.u.U;

public class GroupOf<E extends Manageable>
extends RapidoidThing {
    private final String kind;
    private final Class<E> itemType;
    private final List<E> items = Coll.synchronizedList(new Manageable[0]);
    private final GroupStats stats = new GroupStats();

    public GroupOf(Class<E> itemType) {
        this.kind = Manageables.kindOf(itemType);
        this.itemType = itemType;
        Groups.ALL.add(this);
    }

    public String kind() {
        return this.kind;
    }

    public Class<E> itemType() {
        return this.itemType;
    }

    public List<E> items() {
        return Collections.unmodifiableList(this.items);
    }

    public GroupStats stats() {
        return this.stats;
    }

    private void checkType(E element) {
        U.notNull(element, "group element", new Object[0]);
        U.must(this.itemType.isAssignableFrom(element.getClass()));
    }

    private void checkDuplicates(E element) {
        U.must(!this.items.contains(element), "The item is already in the group!");
    }

    public void add(E element) {
        this.checkType(element);
        this.checkDuplicates(element);
        this.items.add(element);
        this.stats.added.incrementAndGet();
    }

    public void add(int index, E element) {
        this.checkType(element);
        this.checkDuplicates(element);
        this.items.add(index, element);
        this.stats.added.incrementAndGet();
    }

    public E set(int index, E element) {
        this.checkType(element);
        this.checkDuplicates(element);
        return (E)((Manageable)this.items.set(index, element));
    }

    public E get(int index) {
        return (E)((Manageable)this.items.get(index));
    }

    public E get(String id) {
        E item = this.find(id);
        U.must(item != null, "Cannot find item with id='%s'!", id);
        return item;
    }

    public E find(String id) {
        U.notNull(id, "id", new Object[0]);
        for (Manageable item : this.items) {
            if (!U.eq(id, item.id())) continue;
            return (E)item;
        }
        return null;
    }

    public boolean exists(String id) {
        return this.find(id) != null;
    }

    public E remove(int index) {
        return (E)((Manageable)this.items.remove(index));
    }

    public int indexOf(E element) {
        this.checkType(element);
        return this.items.indexOf(element);
    }

    public void clear() {
        this.items.clear();
    }

    public boolean remove(E element) {
        this.checkType(element);
        return this.items.remove(element);
    }

    public int size() {
        return this.items.size();
    }

    public boolean isEmpty() {
        return this.items.isEmpty();
    }

    public boolean contains(E element) {
        this.checkType(element);
        return this.items.contains(element);
    }

    public String toString() {
        return "GroupOf{kind='" + this.kind + '\'' + ", size=" + this.items.size() + ", stats=" + this.stats + '}';
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        GroupOf groupOf = (GroupOf)o;
        if (this.kind != null ? !this.kind.equals(groupOf.kind) : groupOf.kind != null) {
            return false;
        }
        return this.itemType != null ? this.itemType.equals(groupOf.itemType) : groupOf.itemType == null;
    }

    public int hashCode() {
        int result = this.kind != null ? this.kind.hashCode() : 0;
        result = 31 * result + (this.itemType != null ? this.itemType.hashCode() : 0);
        return result;
    }
}

