/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.env;

import java.io.File;
import org.rapidoid.RapidoidThing;
import org.rapidoid.log.Log;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class RootContext
extends RapidoidThing {
    private final String root;

    private RootContext(String root) {
        this.root = root;
    }

    public String root() {
        return this.root;
    }

    public static RootContext from(String root) {
        if (root != null) {
            File dir = new File(root);
            if (dir.exists()) {
                int count = RootContext.getAppResourcesCount(dir);
                Log.info("Setting root path", "!root", root, "items", count);
            } else {
                Log.warn("Setting non-existing root path", "!root", root);
            }
        }
        return new RootContext(root);
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private static int getAppResourcesCount(File dir) {
        int count = 0;
        if (!dir.isDirectory()) throw U.rte("The configured root path must be a folder: " + dir.getAbsolutePath());
        File[] files = dir.listFiles();
        if (files == null) throw U.rte("Couldn't access the root path: " + dir.getAbsolutePath());
        for (File file : files) {
            if (!Msc.isAppResource(file.getName())) continue;
            ++count;
        }
        return count;
    }
}

