/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.env;

import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.Callable;
import org.rapidoid.collection.Coll;
import org.rapidoid.commons.Err;
import org.rapidoid.config.RapidoidInitializer;
import org.rapidoid.env.Env;
import org.rapidoid.env.EnvMode;
import org.rapidoid.env.EnvProperties;
import org.rapidoid.env.RapidoidEnv;
import org.rapidoid.log.Log;
import org.rapidoid.scan.ClasspathUtil;
import org.rapidoid.u.U;
import org.rapidoid.util.LazyInit;
import org.rapidoid.util.Msc;

public class Environment
extends RapidoidInitializer {
    private volatile Set<String> profiles;
    private volatile Set<String> profilesView;
    private volatile EnvMode mode;
    private volatile List<String> args;
    private volatile List<String> argsView;
    private final EnvProperties properties = new EnvProperties();
    private final LazyInit<Map<String, String>> argsAsMap = new LazyInit<Map<String, String>>(new Callable<Map<String, String>>(){

        @Override
        public Map<String, String> call() throws Exception {
            U.notNull(Environment.this.args, "environment args", new Object[0]);
            return Msc.parseArgs(Environment.this.args);
        }
    });

    public Environment() {
        this.reset();
    }

    public Set<String> profiles() {
        this.makeSureIsInitialized();
        return this.profilesView;
    }

    public EnvMode mode() {
        this.makeSureIsInitialized();
        return this.mode;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void makeSureIsInitialized() {
        if (this.profiles == null || this.mode == null) {
            Environment environment = this;
            synchronized (environment) {
                if (this.profiles == null || this.mode == null) {
                    this.initModeAndProfiles();
                }
            }
        }
    }

    public synchronized void reset() {
        this.profiles = null;
        this.mode = null;
        this.argsAsMap.reset();
        this.setArgs(new String[0]);
    }

    private void initModeAndProfiles() {
        boolean dev;
        if (U.isEmpty(this.profiles)) {
            this.profiles = Coll.synchronizedSet(new String[0]);
            this.profiles.addAll(Environment.retrieveProfiles());
            this.profilesView = Collections.unmodifiableSet(this.profiles);
        }
        boolean production = Env.hasInitial("mode", "production") || this.profiles.contains("production");
        boolean test = Env.hasInitial("mode", "test") || this.profiles.contains("test");
        boolean bl = dev = Env.hasInitial("mode", "dev") || this.profiles.contains("dev");
        if (!(production || test || dev)) {
            this.mode = Environment.inferMode();
            if (!Environment.silent()) {
                Log.info("No production/dev/test mode was configured, inferring mode", "!mode", (Object)this.mode);
            }
        } else {
            boolean onlyOne = !(production && dev || dev && test || production && test);
            U.must(onlyOne, "Only one of the ('production', 'dev', 'test') profiles can be specified!");
            if (production) {
                this.mode = EnvMode.PRODUCTION;
            } else if (dev) {
                this.mode = EnvMode.DEV;
            } else if (test) {
                this.mode = EnvMode.TEST;
            } else {
                throw Err.notExpected();
            }
        }
        String modeProfile = this.mode.name().toLowerCase();
        if (!Environment.silent()) {
            Log.debug("Automatically activating mode-specific profile", "!profile", modeProfile);
        }
        this.profiles.add(modeProfile);
        if (Msc.isPlatform()) {
            this.profiles.add("platform");
        }
        RapidoidEnv.touch();
        if (!Environment.silent()) {
            Log.info("Initialized environment", "!mode", (Object)this.mode, "!profiles", this.profiles);
        }
    }

    private static boolean silent() {
        return Msc.isSilent();
    }

    private static EnvMode inferMode() {
        if (Msc.isInsideTest()) {
            return EnvMode.TEST;
        }
        return ClasspathUtil.getClasspathFolders().isEmpty() ? EnvMode.PRODUCTION : EnvMode.DEV;
    }

    private static List<String> retrieveProfiles() {
        List<String> profiles;
        String profilesLst = Env.initial("profiles");
        if (U.notEmpty(profilesLst)) {
            List<String> profiles2 = U.list(profilesLst.split("\\s*\\,\\s*"));
            if (!Environment.silent()) {
                Log.info("Configuring active profiles", "!profiles", profiles2);
            }
            return profiles2;
        }
        if (!Msc.isPlatform()) {
            if (!Environment.silent()) {
                Log.info("No profiles were specified, activating 'default' profile");
            }
            profiles = U.list("default");
        } else {
            profiles = U.list();
        }
        return profiles;
    }

    public void setArgs(String ... args) {
        this.args = Coll.synchronizedList(args);
        this.argsView = Collections.unmodifiableList(this.args);
        this.argsAsMap.reset();
    }

    public List<String> args() {
        return this.argsView;
    }

    public boolean hasProfile(String profileName) {
        return this.profiles().contains(profileName);
    }

    public boolean hasAnyProfile(String ... profileNames) {
        for (String profileName : profileNames) {
            if (!this.hasProfile(profileName)) continue;
            return true;
        }
        return false;
    }

    public synchronized void setProfiles(String ... activeProfiles) {
        if (U.isEmpty(this.profiles)) {
            this.profiles = Coll.synchronizedSet(new String[0]);
            this.profilesView = Collections.unmodifiableSet(this.profiles);
        }
        Collections.addAll(this.profiles, activeProfiles);
        this.mode = null;
        this.initModeAndProfiles();
        if (!Environment.silent()) {
            Log.info("Activating custom profiles", "!activating", activeProfiles, "!resulting profiles", this.profiles, "!resulting mode", (Object)this.mode);
        }
    }

    public boolean isInitialized() {
        return this.mode != null;
    }

    public EnvProperties properties() {
        RapidoidEnv.touch();
        return this.properties;
    }

    public Map<String, String> argsAsMap() {
        RapidoidEnv.touch();
        return this.argsAsMap.get();
    }
}

