/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.env;

import java.util.Collections;
import java.util.Map;
import org.rapidoid.RapidoidThing;
import org.rapidoid.collection.Coll;
import org.rapidoid.u.U;

public class EnvProperties
extends RapidoidThing {
    final Map<String, Object> props = Coll.synchronizedMap();

    public EnvProperties() {
        this.init();
    }

    private void init() {
        for (Map.Entry<String, String> entry : System.getenv().entrySet()) {
            this.set(entry.getKey(), entry.getValue());
        }
        for (Map.Entry<Object, Object> entry : System.getProperties().entrySet()) {
            this.set(U.str(entry.getKey()), entry.getValue());
        }
    }

    private void set(String key, Object value) {
        String propKey = this.normalize(U.str(key));
        this.props.put(propKey, value);
    }

    public Object get(String key) {
        U.notNull(key, "key", new Object[0]);
        return this.props.get(this.normalize(key));
    }

    public boolean has(String key, Object value) {
        return String.valueOf(this.get(key)).equalsIgnoreCase(String.valueOf(value));
    }

    private String normalize(String key) {
        return key.toUpperCase().replace('.', '_');
    }

    public String toString() {
        return this.props.toString();
    }

    public Map<String, Object> asMap() {
        return Collections.unmodifiableMap(this.props);
    }

    public boolean hasPrefix(String prefix) {
        prefix = this.normalize(prefix);
        for (String key : this.props.keySet()) {
            if (!key.startsWith(prefix)) continue;
            return true;
        }
        return false;
    }
}

