/*
 * Decompiled with CFR 0.152.
 */
package org.rapidoid.env;

import java.util.List;
import java.util.Map;
import java.util.Set;
import org.rapidoid.RapidoidThing;
import org.rapidoid.config.Conf;
import org.rapidoid.env.EnvMode;
import org.rapidoid.env.EnvProperties;
import org.rapidoid.env.Environment;
import org.rapidoid.env.RapidoidEnv;
import org.rapidoid.env.RootContext;
import org.rapidoid.u.U;
import org.rapidoid.util.Msc;

public class Env
extends RapidoidThing {
    private static final Environment env = new Environment();
    private static volatile RootContext rootCtx;

    public static void reset() {
        env.reset();
        rootCtx = null;
        RapidoidEnv.reset();
    }

    public static boolean production() {
        return Env.mode() == EnvMode.PRODUCTION;
    }

    public static boolean test() {
        return Env.mode() == EnvMode.TEST;
    }

    public static boolean dev() {
        return Env.mode() == EnvMode.DEV;
    }

    public static boolean isInitialized() {
        return env.isInitialized();
    }

    public static EnvMode mode() {
        return env.mode();
    }

    public static Set<String> profiles() {
        return env.profiles();
    }

    public static void setProfiles(String ... profiles) {
        env.setProfiles(profiles);
    }

    public static void setArgs(String ... args) {
        U.must(!Env.isInitialized(), "The environment was already initialized!");
        U.must(Env.args().isEmpty(), "The application start-up arguments were already assigned!");
        env.setArgs(args);
        Env.processInitialConfig();
    }

    private static void processInitialConfig() {
        String root = U.or(Env.initial("root"), Env.initial("default_root"));
        Env.setRoot(root);
        String config = Env.initial("config");
        if (config != null) {
            Conf.setFilenameBase(config);
        }
    }

    static String initial(String key) {
        Map<String, String> args = Env.argsAsMap();
        return (String)U.or(args.get(key), args.get(key.toLowerCase()), args.get(key.toUpperCase()), Env.properties().get(key));
    }

    static boolean hasInitial(String key, Object value) {
        return String.valueOf(Env.initial(key)).equalsIgnoreCase(String.valueOf(value));
    }

    public static List<String> args() {
        return env.args();
    }

    public static boolean hasProfile(String profileName) {
        return env.hasProfile(profileName);
    }

    public static boolean hasAnyProfile(String ... profileNames) {
        return env.hasAnyProfile(profileNames);
    }

    public static EnvProperties properties() {
        return env.properties();
    }

    public static Map<String, String> argsAsMap() {
        return env.argsAsMap();
    }

    public static void setRoot(String root) {
        rootCtx = RootContext.from(root);
    }

    public static String root() {
        if (rootCtx != null) {
            return rootCtx.root();
        }
        U.must(!Msc.isPlatform(), "The root context must be initialized for the platform!");
        return null;
    }
}

